/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.scout.commons.EventListenerList;

public class LRUCache<K, V> {
    private long m_nextSecondarySeq = 1L;
    private int m_targetSize = 1000;
    private int m_overflowSize;
    private long m_timeout = -1L;
    private HashMap<K, CacheEntry> m_accessMap;
    private Object m_accessMapLock = new Object();
    private EventListenerList m_listenerList = new EventListenerList();

    public LRUCache(int targetSize, long timeout) {
        this.m_accessMap = new HashMap();
        this.setTargetSize(targetSize);
        this.setTimeout(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        boolean fire = false;
        Object fireValue = null;
        V returnValue = null;
        Object object = this.m_accessMapLock;
        synchronized (object) {
            CacheEntry ce = this.m_accessMap.get(key);
            if (ce != null && ce.isTimeout()) {
                this.m_accessMap.remove(key);
                fire = true;
                fireValue = ce.getValue();
                ce = null;
            }
            if (ce != null) {
                ce.touch();
                returnValue = ce.getValue();
            } else {
                returnValue = null;
            }
        }
        if (fire) {
            this.fireValueDisposed(key, fireValue);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        if (this.m_targetSize <= 0) {
            return;
        }
        boolean fire = false;
        Object fireValue = null;
        Object object = this.m_accessMapLock;
        synchronized (object) {
            this.validateCacheSizeNoLock();
            CacheEntry ce = this.m_accessMap.get(key);
            if (ce != null) {
                Object oldValue = ce.getValue();
                ce.updateValue(value);
                if (oldValue != value) {
                    fire = true;
                    fireValue = oldValue;
                }
            } else {
                ce = new CacheEntry(key, value);
                this.m_accessMap.put(key, ce);
            }
        }
        if (fire) {
            this.fireValueDisposed(key, fireValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(K key) {
        if (this.m_targetSize <= 0) {
            return;
        }
        boolean fire = false;
        Object fireValue = null;
        Object object = this.m_accessMapLock;
        synchronized (object) {
            CacheEntry ce = this.m_accessMap.remove(key);
            if (ce != null) {
                fire = true;
                fireValue = ce.getValue();
            }
        }
        if (fire) {
            this.fireValueDisposed(key, fireValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        HashMap<K, CacheEntry> oldMap;
        Object object = this.m_accessMapLock;
        synchronized (object) {
            oldMap = this.m_accessMap;
            this.m_accessMap = new HashMap();
        }
        for (CacheEntry ce : oldMap.values()) {
            this.fireValueDisposed(ce.getKey(), ce.getValue());
        }
    }

    public void setTimeout(long timeout) {
        this.m_timeout = timeout;
    }

    public long getTimeout() {
        return this.m_timeout;
    }

    public void setTargetSize(int size) {
        this.m_targetSize = size;
        this.m_overflowSize = this.m_targetSize * 3 / 2;
    }

    public int getTargetSize() {
        return this.m_targetSize;
    }

    public Map<K, V> entries() {
        return this.getCacheContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, V> getCacheContent() {
        Object object = this.m_accessMapLock;
        synchronized (object) {
            HashMap map = new HashMap();
            for (CacheEntry ce : this.m_accessMap.values()) {
                if (ce.isTimeout()) continue;
                map.put(ce.getKey(), ce.getValue());
            }
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<K> keySet() {
        Object object = this.m_accessMapLock;
        synchronized (object) {
            HashSet set = new HashSet(this.m_accessMap.size());
            for (CacheEntry ce : this.m_accessMap.values()) {
                if (ce.isTimeout()) continue;
                set.add(ce.getKey());
            }
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(K key) {
        Object object = this.m_accessMapLock;
        synchronized (object) {
            return this.m_accessMap.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<V> values() {
        Object object = this.m_accessMapLock;
        synchronized (object) {
            ArrayList list = new ArrayList(this.m_accessMap.size());
            for (CacheEntry ce : this.m_accessMap.values()) {
                if (ce.isTimeout()) continue;
                list.add(ce.getValue());
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsValue(V value) {
        Object object = this.m_accessMapLock;
        synchronized (object) {
            CacheEntry ce;
            Iterator<CacheEntry> iterator = this.m_accessMap.values().iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                ce = iterator.next();
                if (ce.getValue() != null || value != null) continue;
                return true;
            } while (ce.getValue() == null || !ce.getValue().equals(value));
            return true;
        }
    }

    private void validateCacheSizeNoLock() {
        if (this.m_accessMap.size() >= this.m_overflowSize) {
            TreeSet<CacheEntry> sortSet = new TreeSet<CacheEntry>(new CacheEntryTimestampComparator());
            for (CacheEntry ce : this.m_accessMap.values()) {
                sortSet.add(ce);
            }
            this.m_accessMap.clear();
            int count = 0;
            for (CacheEntry ce : sortSet) {
                if (count > this.m_targetSize || ce.isTimeout()) {
                    this.fireValueDisposed(ce.getKey(), ce.getValue());
                    continue;
                }
                this.m_accessMap.put(ce.getKey(), ce);
                ++count;
            }
        }
    }

    public void addDisposeListener(DisposeListener listener) {
        this.m_listenerList.add(DisposeListener.class, listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.m_listenerList.remove(DisposeListener.class, listener);
    }

    private void fireValueDisposed(Object key, Object value) {
        EventListener[] a = this.m_listenerList.getListeners(DisposeListener.class);
        int i = 0;
        while (i < a.length) {
            ((DisposeListener)a[i]).valueDisposed(key, value);
            ++i;
        }
    }

    private class CacheEntry {
        private K m_key;
        private V m_value;
        private long m_timestamp;
        private Long m_secondarySeq;

        public CacheEntry(K key, V value) {
            this.m_key = key;
            this.m_value = value;
            this.touch();
        }

        public K getKey() {
            return this.m_key;
        }

        public V getValue() {
            return this.m_value;
        }

        public long getTimestamp() {
            return this.m_timestamp;
        }

        public boolean isTimeout() {
            return LRUCache.this.m_timeout > 0L && this.m_timestamp + LRUCache.this.m_timeout < System.currentTimeMillis();
        }

        public void updateValue(V newValue) {
            this.m_value = newValue;
            this.touch();
        }

        public void touch() {
            this.m_timestamp = System.currentTimeMillis();
        }

        public String toString() {
            return "LRU[" + this.m_key + "," + this.m_value + "]";
        }
    }

    private class CacheEntryTimestampComparator
    implements Comparator<CacheEntry> {
        private CacheEntryTimestampComparator() {
        }

        @Override
        public int compare(CacheEntry ca, CacheEntry cb) {
            if (ca.m_timestamp < cb.m_timestamp) {
                return 1;
            }
            if (ca.m_timestamp > cb.m_timestamp) {
                return -1;
            }
            if (ca.m_secondarySeq == null) {
                LRUCache lRUCache = LRUCache.this;
                long l = lRUCache.m_nextSecondarySeq;
                lRUCache.m_nextSecondarySeq = l + 1L;
                ca.m_secondarySeq = l;
            }
            if (cb.m_secondarySeq == null) {
                LRUCache lRUCache = LRUCache.this;
                long l = lRUCache.m_nextSecondarySeq;
                lRUCache.m_nextSecondarySeq = l + 1L;
                cb.m_secondarySeq = l;
            }
            return ca.m_secondarySeq.compareTo(cb.m_secondarySeq);
        }
    }

    public static interface DisposeListener
    extends EventListener {
        public void valueDisposed(Object var1, Object var2);
    }
}

