/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.beans;

import java.lang.reflect.Method;

public class FastPropertyDescriptor {
    private final Class beanClass;
    private final String name;
    private Class propertyType;
    private Method readMethod;
    private Method writeMethod;

    public FastPropertyDescriptor(Class<?> beanClazz, String name, Method readMethod, Method writeMethod) {
        this.beanClass = beanClazz;
        this.name = name;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        this.propertyType = FastPropertyDescriptor.findPropertyType(readMethod, writeMethod);
    }

    FastPropertyDescriptor(Class<?> beanClazz, String name) {
        this.beanClass = beanClazz;
        this.name = name;
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    void setPropertyType(Class type) {
        this.propertyType = type;
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    void setReadMethod(Method readMethod) {
        this.readMethod = readMethod;
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    void setWriteMethod(Method writeMethod) {
        this.writeMethod = writeMethod;
    }

    public int hashCode() {
        int result = 0;
        result ^= this.getName().hashCode();
        result ^= this.getPropertyType() == null ? 0 : this.getPropertyType().hashCode();
        result ^= this.getReadMethod() == null ? 0 : this.getReadMethod().hashCode();
        return result ^= this.getWriteMethod() == null ? 0 : this.getWriteMethod().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof FastPropertyDescriptor) {
            FastPropertyDescriptor other = (FastPropertyDescriptor)obj;
            Method otherReadMethod = other.getReadMethod();
            Method otherWriteMethod = other.getWriteMethod();
            if (!FastPropertyDescriptor.compareMethods(this.getReadMethod(), otherReadMethod)) {
                return false;
            }
            if (!FastPropertyDescriptor.compareMethods(this.getWriteMethod(), otherWriteMethod)) {
                return false;
            }
            if (this.getPropertyType() == other.getPropertyType()) {
                return true;
            }
        }
        return false;
    }

    private static String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        return String.valueOf(Character.toUpperCase(s.charAt(0))) + s.substring(1);
    }

    private static boolean compareMethods(Method a, Method b) {
        if (a == null != (b == null)) {
            return false;
        }
        return a == null || b == null || a.equals(b);
    }

    private static Class findPropertyType(Method readMethod, Method writeMethod) {
        if (readMethod != null) {
            return readMethod.getReturnType();
        }
        if (writeMethod != null) {
            return writeMethod.getParameterTypes()[0];
        }
        return null;
    }
}

