/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.exception;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.exception.ProcessingStatus;

public class ProcessingException
extends Exception
implements Serializable {
    private static final long serialVersionUID = 1L;
    private IProcessingStatus m_status;
    private transient boolean m_consumed;

    public ProcessingException() {
        super("undefined", null);
    }

    public ProcessingException(String message) {
        this(new ProcessingStatus(null, message, null, 0, 4));
    }

    public ProcessingException(String message, Throwable cause) {
        this(new ProcessingStatus(null, message, cause, 0, 4));
    }

    public ProcessingException(String message, Throwable cause, int errorCode) {
        this(new ProcessingStatus(null, message, cause, errorCode, 4));
    }

    public ProcessingException(String message, Throwable cause, int errorCode, int severity) {
        this(new ProcessingStatus(null, message, cause, errorCode, severity));
    }

    public ProcessingException(String title, String message) {
        this(new ProcessingStatus(title, message, null, 0, 4));
    }

    public ProcessingException(String title, String message, Throwable cause) {
        this(new ProcessingStatus(title, message, cause, 0, 4));
    }

    public ProcessingException(String title, String message, Throwable cause, int errorCode) {
        this(new ProcessingStatus(title, message, cause, errorCode, 4));
    }

    public ProcessingException(String title, String message, Throwable cause, int errorCode, int severity) {
        this(new ProcessingStatus(title, message, cause, errorCode, severity));
    }

    public ProcessingException(IStatus status) {
        super(status.getMessage(), status.getException());
        this.m_status = status instanceof ProcessingStatus ? (ProcessingStatus)status : new ProcessingStatus(status);
    }

    public IProcessingStatus getStatus() {
        return this.m_status;
    }

    public void setStatus(IProcessingStatus status) {
        this.m_status = status;
    }

    public void addContextMessage(String s) {
        this.m_status.addContextMessage(s);
    }

    public boolean isConsumed() {
        return this.m_consumed;
    }

    public void consume() {
        this.m_consumed = true;
    }

    public boolean isInterruption() {
        return this.m_status != null && this.m_status.getCause() instanceof InterruptedException;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.m_status.toString() + "]";
    }

    public static StackTraceElement[] unionStackTrace(Throwable t) {
        ArrayList<StackTraceElement> list = new ArrayList<StackTraceElement>();
        while (t != null) {
            list.addAll(0, Arrays.asList(t.getStackTrace()));
            t = t.getCause();
        }
        return list.toArray(new StackTraceElement[list.size()]);
    }
}

