/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.exception;

import java.io.Serializable;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.scout.commons.exception.IProcessingStatus;

public class ProcessingStatus
implements IProcessingStatus,
Serializable {
    private static final long serialVersionUID = 1L;
    private int m_severity;
    private int m_code;
    private String m_plugin = "";
    private String m_title;
    private String m_message = "";
    private ArrayList<String> m_contextMessages;
    private Throwable m_cause = null;

    public ProcessingStatus(String message, int severity) {
        this.setMessage(message);
        this.setSeverity(severity);
    }

    public ProcessingStatus(String title, String message, int severity) {
        this.setTitle(title);
        this.setMessage(message);
        this.setSeverity(severity);
    }

    public ProcessingStatus(String message, Throwable cause, int code, int severity) {
        this.setMessage(message);
        this.setException(cause);
        this.setCode(code);
        this.setSeverity(severity);
    }

    public ProcessingStatus(String title, String message, Throwable cause, int code, int severity) {
        this.setTitle(title);
        this.setMessage(message);
        this.setException(cause);
        this.setCode(code);
        this.setSeverity(severity);
    }

    public ProcessingStatus(IStatus s) {
        if (s != null) {
            this.setMessage(s.getMessage());
            this.setException(s.getException());
            this.setCode(s.getCode());
            this.setSeverity(s.getSeverity());
            if (s instanceof IProcessingStatus) {
                this.setTitle(((IProcessingStatus)s).getTitle());
            }
        }
    }

    public IProcessingStatus[] getChildren() {
        return new IProcessingStatus[0];
    }

    public boolean isMultiStatus() {
        return false;
    }

    public int getCode() {
        return this.m_code;
    }

    @Override
    public Throwable getCause() {
        return this.m_cause;
    }

    public Throwable getException() {
        return this.m_cause;
    }

    public String getPlugin() {
        return this.m_plugin;
    }

    public void setPlugin(String plugin) {
        this.m_plugin = plugin;
    }

    public String getMessage() {
        return this.m_message;
    }

    @Override
    public String getTitle() {
        return this.m_title;
    }

    public int getSeverity() {
        return this.m_severity;
    }

    public boolean isOK() {
        return this.m_severity == 0;
    }

    public boolean matches(int severityMask) {
        return (this.getSeverity() & severityMask) != 0;
    }

    public void setCode(int code) {
        this.m_code = code;
    }

    public void setException(Throwable exception) {
        this.m_cause = exception;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public void setMessage(String message) {
        this.m_message = message;
    }

    @Override
    public void addContextMessage(String message) {
        if (message != null) {
            if (this.m_contextMessages == null) {
                this.m_contextMessages = new ArrayList();
            }
            this.m_contextMessages.add(0, message);
        }
    }

    @Override
    public String[] getContextMessages() {
        return this.m_contextMessages != null ? this.m_contextMessages.toArray(new String[0]) : new String[]{};
    }

    public void setSeverity(int severity) {
        switch (severity) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal severity: " + severity);
            }
        }
        this.m_severity = severity;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(this.getClass().getSimpleName()) + "[");
        switch (this.getSeverity()) {
            case 1: {
                buf.append("INFO");
                break;
            }
            case 2: {
                buf.append("WARNING");
                break;
            }
            case 4: {
                buf.append("ERROR");
                break;
            }
            case 16: {
                buf.append("FATAL");
                break;
            }
            case 0: {
                buf.append("OK");
                break;
            }
            case 8: {
                buf.append("CANCEL");
                break;
            }
            default: {
                buf.append("severity=" + this.getSeverity());
            }
        }
        buf.append(" code=" + this.m_code);
        if (this.m_contextMessages != null) {
            for (String s : this.m_contextMessages) {
                buf.append(" ");
                buf.append(s);
                buf.append(" /");
            }
        }
        buf.append(" ");
        buf.append(this.m_message);
        if (this.m_cause != null) {
            buf.append(" ");
            buf.append(this.m_cause);
        }
        buf.append("]");
        return buf.toString();
    }
}

