/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.logger.analysis;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.logger.analysis.ILogFilter;
import org.eclipse.scout.commons.logger.analysis.LogEntry;

public abstract class AbstractLogFilter
implements ILogFilter {
    private static final Pattern SIMPLE_LOG_PARSE_PATTERN = Pattern.compile("^\\[([^]]+)\\]\\s+(....-..-.....:..:..\\....)\\s+([^\\s]+)\\s+([^\\s]+)\\s+(.*)$");
    private static final Pattern ECLIPSE_LOG_PARSE_PATTERN1 = Pattern.compile("^\\!ENTRY\\s+([^\\s]+)\\s+([^\\s]+)\\s+([^\\s]+)\\s+(....-..-.....:..:..\\....)$");
    private static final Pattern ECLIPSE_LOG_PARSE_PATTERN2 = Pattern.compile("^\\!SESSION\\s+(....-..-.....:..:..\\....).*$");
    private static final SimpleDateFormat ECLIPSE_LOG_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final SimpleDateFormat SIMPLE_LOG_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private String m_formatPattern;
    private SimpleDateFormat m_dateFormat;

    public AbstractLogFilter() {
        this("[{1}] {2} {3} {4} {5}", "yyyy-MM-dd HH:mm:ss.SSS");
    }

    public AbstractLogFilter(String formatPattern, String dateFormat) {
        this.m_formatPattern = formatPattern;
        this.m_dateFormat = new SimpleDateFormat(dateFormat);
    }

    @Override
    public boolean isIgnoredLine(String line) {
        return line.startsWith("PasswordSecurityFilter::");
    }

    @Override
    public boolean isLogEntryStartLine(String line) {
        if (SIMPLE_LOG_PARSE_PATTERN.matcher(line).matches()) {
            return true;
        }
        if (ECLIPSE_LOG_PARSE_PATTERN1.matcher(line).matches()) {
            return true;
        }
        return ECLIPSE_LOG_PARSE_PATTERN2.matcher(line).matches();
    }

    @Override
    public LogEntry parse(List<String> entry) throws Exception {
        StringBuffer attachmentBuf;
        Matcher m;
        LogEntry e = null;
        if (e == null && (m = SIMPLE_LOG_PARSE_PATTERN.matcher(entry.get(0))).matches()) {
            e = new LogEntry();
            e.severity = m.group(1);
            e.date = SIMPLE_LOG_DATE_FORMAT.parse(m.group(2));
            e.thread = m.group(3);
            e.source = m.group(4);
            e.message = m.group(5);
            if (entry.size() > 1) {
                StringBuffer b = new StringBuffer();
                int i = 1;
                while (i < entry.size()) {
                    if (b.length() > 0) {
                        b.append("\n");
                    }
                    b.append(entry.get(i));
                    ++i;
                }
                e.attachment = b.toString();
            } else {
                e.attachment = "";
            }
        }
        if (e == null && (m = ECLIPSE_LOG_PARSE_PATTERN1.matcher(entry.get(0))).matches()) {
            e = new LogEntry();
            e.severity = "LOG";
            e.thread = "";
            e.source = m.group(1);
            e.date = ECLIPSE_LOG_DATE_FORMAT.parse(m.group(4));
            e.message = "";
            attachmentBuf = new StringBuffer();
            for (String line : entry) {
                if (line.startsWith("!ENTRY")) continue;
                if (line.startsWith("!MESSAGE")) {
                    if (e.message.length() != 0) continue;
                    e.message = line.substring(9);
                    continue;
                }
                if (line.startsWith("!STACK") || line.startsWith("!SESSION")) continue;
                if (attachmentBuf.length() > 0) {
                    attachmentBuf.append("\n");
                }
                attachmentBuf.append(line);
            }
            e.attachment = attachmentBuf.toString().trim();
        }
        if (e == null && (m = ECLIPSE_LOG_PARSE_PATTERN2.matcher(entry.get(0))).matches()) {
            e = new LogEntry();
            e.severity = "LOG";
            e.thread = "";
            e.source = "";
            e.date = ECLIPSE_LOG_DATE_FORMAT.parse(m.group(1));
            e.message = "New Session";
            attachmentBuf = new StringBuffer();
            for (String line : entry) {
                if (attachmentBuf.length() > 0) {
                    attachmentBuf.append("\n");
                }
                attachmentBuf.append(line);
            }
            e.attachment = attachmentBuf.toString().trim();
        }
        if (e.source.indexOf("LogExceptionHandlerService.handleException") >= 0 && (m = Pattern.compile("\\sat\\s([^\\s(:]+\\([^\\s:]+\\:[0-9]+\\))").matcher(e.attachment)).find()) {
            e.source = m.group(1);
        }
        return e;
    }

    @Override
    public LogEntry filter(LogEntry e) {
        return e;
    }

    @Override
    public String formatContext(LogEntry e) {
        return String.valueOf(this.m_dateFormat.format(e.date)) + " " + e.thread + " " + e.message;
    }

    @Override
    public String format(LogEntry e) {
        StringBuffer b = new StringBuffer();
        String line = this.m_formatPattern;
        line = line.replace("{1}", e.severity);
        line = line.replace("{2}", this.m_dateFormat.format(e.date));
        line = line.replace("{3}", e.thread);
        line = line.replace("{4}", e.source);
        line = line.replace("{5}", e.message);
        b.append(line);
        b.append("\n");
        if (e.attachment.length() > 0) {
            b.append(e.attachment);
            b.append("\n");
        }
        return b.toString();
    }
}

