/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.logger.internal.eclipse;

import java.util.logging.LogRecord;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.internal.Activator;
import org.eclipse.scout.commons.logger.EclipseLogUtility;
import org.eclipse.scout.commons.logger.JavaLogUtility;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.logger.internal.AbstractScoutLogger;
import org.osgi.framework.Bundle;

public class EclipseLogWrapper
extends AbstractScoutLogger {
    private String m_name;
    private int m_level;

    public EclipseLogWrapper(String name, int level) {
        this.m_name = name;
        this.m_level = level;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public int getLevel() {
        Integer globalLogLevel = ScoutLogManager.getGlobalLogLevel();
        if (globalLogLevel != null) {
            return globalLogLevel;
        }
        return this.m_level;
    }

    @Override
    public void setLevel(int level) {
        this.m_level = level;
    }

    @Override
    protected void logImpl(LogRecord record) {
        String path = this.stripOffLastSegment(record.getLoggerName());
        Bundle bundle = null;
        while (path != null) {
            bundle = Platform.getBundle((String)path);
            if (bundle != null) break;
            path = this.stripOffLastSegment(path);
        }
        if (bundle == null) {
            bundle = Activator.getDefault().getBundle();
        }
        StringBuffer buf = new StringBuffer();
        if (record.getSourceClassName() != null) {
            buf.append(record.getSourceClassName());
            if (record.getSourceMethodName() != null) {
                buf.append(".");
                buf.append(record.getSourceMethodName());
            }
        } else {
            buf.append(record.getLoggerName());
        }
        if (bundle != null) {
            int scoutLevel = JavaLogUtility.javaToScoutLevel(record.getLevel());
            int severity = EclipseLogUtility.scoutToEclipseLevel(scoutLevel);
            Status status = new Status(severity, bundle.getSymbolicName(), 0, String.valueOf(buf.toString()) + " " + record.getMessage(), record.getThrown());
            Platform.getLog((Bundle)bundle).log((IStatus)status);
        } else {
            System.err.println("Failed logging entry " + record.getLoggerName() + " " + buf.toString() + " " + record.getMessage());
        }
    }

    public String stripOffLastSegment(String s) {
        if (s == null) {
            return null;
        }
        int i = s.lastIndexOf(46);
        if (i >= 0) {
            return (s = s.substring(0, i).trim()).length() > 0 ? s : null;
        }
        return null;
    }
}

