/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.osgi.util.NLS;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.internal.jdt.NlsJdtHandler;

public class NlsTypeSourceFilter
implements IJavaSearchScope {
    private IProject[] m_projects;

    public NlsTypeSourceFilter(IProject[] projects) {
        this.m_projects = projects;
    }

    public boolean encloses(String resourcePath) {
        IProject[] iProjectArray = this.m_projects;
        int n = this.m_projects.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            IProject project = iProjectArray[n2];
            if (resourcePath != null && resourcePath.contains(project.getName()) && (file = project.getFile((IPath)new Path(resourcePath = resourcePath.replace("/" + project.getName(), "")))) != null && file.exists()) {
                IType type = NlsJdtHandler.getITypeForFile(file);
                try {
                    return NlsJdtHandler.isDescendant(type, NLS.class);
                }
                catch (JavaModelException e) {
                    NlsCore.logWarning(e);
                }
            }
            ++n2;
        }
        return false;
    }

    public boolean encloses(IJavaElement element) {
        if (element.getResource() instanceof IFile) {
            IType type = NlsJdtHandler.getITypeForFile((IFile)element.getResource());
            try {
                return NlsJdtHandler.isDescendant(type, NLS.class);
            }
            catch (JavaModelException e) {
                NlsCore.logWarning(e);
                return false;
            }
        }
        return false;
    }

    public IPath[] enclosingProjectsAndJars() {
        IPath[] paths = new IPath[this.m_projects.length];
        int i = 0;
        while (i < this.m_projects.length) {
            paths[i] = this.m_projects[i].getFullPath();
            ++i;
        }
        return paths;
    }

    @Deprecated
    public boolean includesBinaries() {
        return false;
    }

    @Deprecated
    public boolean includesClasspaths() {
        return false;
    }

    @Deprecated
    public void setIncludesBinaries(boolean includesBinaries) {
    }

    @Deprecated
    public void setIncludesClasspaths(boolean includesClasspaths) {
    }
}

