/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.nls.sdk.internal.model.PropertySupport;
import org.eclipse.scout.nls.sdk.model.util.AbstractChangeLogModel;

public class PropertyBasedModel
extends AbstractChangeLogModel
implements Comparable<PropertyBasedModel> {
    private PropertySupport propertySupport = new PropertySupport(this);
    private PropertyBasedModel m_original;
    private List<String> m_properties = new LinkedList<String>();
    private P_ChangeLogPropertyListener m_changeLogPropertyListener = new P_ChangeLogPropertyListener();
    private boolean m_hasChanges;
    private boolean m_pauseChangeLog;

    public PropertyBasedModel() {
    }

    public PropertyBasedModel(PropertyBasedModel model) {
        Set<Map.Entry<String, Object>> props = model.getPropertiesMap().entrySet();
        for (Map.Entry<String, Object> entry : props) {
            this.propertySupport.setProperty(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public int compareTo(PropertyBasedModel o) {
        return 1;
    }

    public void setPauseChangeLog(boolean pause) {
        this.m_pauseChangeLog = pause;
    }

    public void startChangeLog() {
        this.m_original = new PropertyBasedModel(this);
        this.addPropertyChangeListener(this.m_changeLogPropertyListener);
    }

    public void stopChangeLog() {
        this.m_original = null;
        this.removePropertyChangeListener(this.m_changeLogPropertyListener);
        this.m_hasChanges = false;
    }

    public boolean hasChanges() {
        return this.m_hasChanges;
    }

    public IStatus commitChanges(IProgressMonitor monitor) {
        this.m_original = new PropertyBasedModel(this);
        this.revalidateChangeLog();
        return Status.OK_STATUS;
    }

    protected boolean calculateChanges() {
        return !this.equals(this.m_original);
    }

    private void revalidateChangeLog() {
        boolean changed = this.calculateChanges();
        if (this.m_hasChanges != changed) {
            this.m_hasChanges = changed;
            this.fireModelChanged();
        }
    }

    protected void setPropertyString(String key, String value) {
        this.setProperty(key, value);
    }

    protected String getPropertyString(String key) {
        return (String)this.getProperty(key);
    }

    protected boolean getPropertyBool(String key) {
        Boolean val = (Boolean)this.getProperty(key);
        if (val == null) {
            return false;
        }
        return val;
    }

    protected void setPropertyBool(String key, boolean value) {
        this.setProperty(key, new Boolean(value));
    }

    protected void setProperty(String key, Object value) {
        if (this.m_pauseChangeLog && this.m_original != null) {
            this.m_original.setProperty(key, value);
        }
        this.propertySupport.setProperty(key, value);
    }

    protected Object getProperty(String key) {
        return this.propertySupport.getProperty(key);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public void fireAllProperties() {
        ArrayList<String> props = new ArrayList<String>(this.m_properties);
        for (String prop : props) {
            this.propertySupport.firePropertyChange(prop, null, this.propertySupport.getProperty(prop));
        }
    }

    public void clearProperties() {
        if (this.m_pauseChangeLog && this.m_original != null) {
            this.m_original.clearProperties();
        }
        this.propertySupport.clearProperties();
    }

    public void clearPropertiesFire() {
        if (this.m_pauseChangeLog && this.m_original != null) {
            this.m_original.clearPropertiesFire();
        }
        this.propertySupport.clearPropertiesFire();
    }

    public void removeProperty(String key) {
        if (this.m_pauseChangeLog && this.m_original != null) {
            this.m_original.removeProperty(key);
        }
        this.propertySupport.removeProperty(key);
    }

    public Map<String, Object> getPropertiesMap() {
        return this.propertySupport.getPropertiesMap();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PropertyBasedModel)) {
            return false;
        }
        PropertyBasedModel toCompare = (PropertyBasedModel)obj;
        TreeSet<String> set = new TreeSet<String>();
        set.addAll(this.getPropertiesMap().keySet());
        set.addAll(toCompare.getPropertiesMap().keySet());
        for (String key : set) {
            Object o1 = this.getProperty(key);
            Object o2 = toCompare.getProperty(key);
            if (o1 == null && o2 == null) continue;
            if (o1 == null || o2 == null) {
                return false;
            }
            if (this.getProperty(key).equals(toCompare.getProperty(key))) continue;
            return false;
        }
        return true;
    }

    private class P_ChangeLogPropertyListener
    implements PropertyChangeListener {
        private P_ChangeLogPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PropertyBasedModel.this.revalidateChangeLog();
        }
    }
}

