/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.model.workspace;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.internal.model.TypeHandler;
import org.eclipse.scout.nls.sdk.internal.model.workspace.NlsType;
import org.eclipse.scout.nls.sdk.internal.model.workspace.nlsfile.AbstractNlsFile;
import org.eclipse.scout.nls.sdk.internal.model.workspace.nlsfile.PlatformNlsFile;
import org.eclipse.scout.nls.sdk.internal.model.workspace.nlsfile.WorkspaceNlsFile;
import org.eclipse.scout.nls.sdk.internal.model.workspace.project.NlsProject;
import org.eclipse.scout.nls.sdk.internal.model.workspace.translationfile.AbstractTranslationFile;
import org.eclipse.scout.nls.sdk.internal.model.workspace.translationfile.PlatformTranslationFile;
import org.eclipse.scout.nls.sdk.internal.model.workspace.translationfile.WorkspaceTranslationFile;
import org.eclipse.scout.nls.sdk.model.workspace.INlsWorkspace;
import org.eclipse.scout.nls.sdk.model.workspace.translationFile.ITranslationFile;

public class NlsWorkspace
implements INlsWorkspace {
    private HashMap<String, NlsProject> m_projects = new HashMap();

    @Override
    public NlsProject findNlsProject(IProject project, IProgressMonitor monitor) throws CoreException {
        return this.findNlsProject(project, "translation.nls", monitor);
    }

    @Override
    public NlsProject findNlsProject(IProject project, String fileName, IProgressMonitor monitor) throws CoreException {
        IFile nlsResource = project.getFile(fileName);
        NlsProject nlsProject = this.findNlsProject(nlsResource, monitor);
        return nlsProject;
    }

    @Override
    public NlsProject findNlsProject(IFile nlsResource, IProgressMonitor monitor) throws CoreException {
        AbstractNlsFile nlsFile = this.loadNlsFile(nlsResource);
        if (nlsFile == null) {
            return null;
        }
        IType type = TypeHandler.getType(nlsFile.getNlsTypeName());
        return this.findNlsProject(type, monitor);
    }

    @Override
    public NlsProject findNlsProject(IType type, IProgressMonitor monitor) throws CoreException {
        if (type == null || !type.exists()) {
            NlsCore.logError("nls type does not exist", new Exception());
            return null;
        }
        String hostPluginId = this.getPluginId((IJavaElement)type);
        NlsProject nlsProject = this.m_projects.get(type.getFullyQualifiedName());
        if (nlsProject == null) {
            nlsProject = new NlsProject(type, hostPluginId);
            type.isBinary();
            this.m_projects.put(type.getFullyQualifiedName(), nlsProject);
        }
        return nlsProject;
    }

    private AbstractNlsFile loadNlsFile(IFile file) throws CoreException {
        AbstractNlsFile nlsFile = null;
        if (file != null && file.exists()) {
            nlsFile = file.isReadOnly() ? new PlatformNlsFile(file.getContents(), file.getName()) : new WorkspaceNlsFile(file);
        }
        return nlsFile;
    }

    @Override
    public ITranslationFile[] loadTranslationFiles(NlsType nlsType, IProgressMonitor monitor) throws CoreException {
        if (nlsType.getType().isReadOnly()) {
            String bundleId = this.getPluginId((IJavaElement)nlsType.getType());
            if (bundleId == null) {
                NlsCore.logWarning("could not find bundle: " + bundleId);
                return new ITranslationFile[0];
            }
            return this.loadTranslationFilesFromPlatform(nlsType, bundleId);
        }
        return this.loadTranslationFilesWorkspace(nlsType, monitor);
    }

    private ITranslationFile[] loadTranslationFilesWorkspace(NlsType nlsType, IProgressMonitor monior) throws CoreException {
        ArrayList<WorkspaceTranslationFile> translationFiles = new ArrayList<WorkspaceTranslationFile>();
        if (nlsType != null && nlsType.getTranslationsFolderName() != null && nlsType.getTranslationsPrefix() != null) {
            Path translationPath = new Path(nlsType.getTranslationsFolderName());
            for (IFile file : NlsCore.getAllTranslations(nlsType.getJavaProject().getProject(), (IPath)translationPath, nlsType.getTranslationsPrefix())) {
                translationFiles.add(new WorkspaceTranslationFile(file));
            }
            List<IProject> workspaceFragments = NlsCore.getWorkspaceFragments(nlsType.getHostPluginId());
            for (IProject fragment : workspaceFragments) {
                for (IFile file : NlsCore.getAllTranslations(fragment, (IPath)translationPath, nlsType.getTranslationsPrefix())) {
                    translationFiles.add(new WorkspaceTranslationFile(file));
                }
            }
        }
        return translationFiles.toArray(new ITranslationFile[translationFiles.size()]);
    }

    private ITranslationFile[] loadTranslationFilesFromPlatform(NlsType nlsType, String bundleId) throws CoreException {
        ArrayList<PlatformTranslationFile> translationFiles = new ArrayList<PlatformTranslationFile>();
        Enumeration eee = Platform.getBundle((String)bundleId).findEntries(nlsType.getTranslationsFolderName(), String.valueOf(nlsType.getTranslationsPrefix()) + "*.properties", false);
        if (eee != null) {
            while (eee.hasMoreElements()) {
                Object o = eee.nextElement();
                if (!(o instanceof URL)) continue;
                try {
                    translationFiles.add(new PlatformTranslationFile(((URL)o).openStream(), NlsCore.getLanguage(((URL)o).getFile())));
                }
                catch (IOException e) {
                    NlsCore.logError("could not load NLS files of bundle '" + bundleId + "'", e);
                }
            }
        }
        return translationFiles.toArray(new AbstractTranslationFile[translationFiles.size()]);
    }

    private String getPluginId(IJavaElement type) {
        if (type.isReadOnly()) {
            Matcher matcher;
            IJavaElement root = type.getAncestor(3);
            String bundleId = null;
            if (root != null && (matcher = Pattern.compile("^([^_]*)_[0-9]+\\.[0-9]+\\.[0-9]+(\\.[^.]+)?\\.jar$").matcher(root.getElementName())).matches()) {
                bundleId = matcher.group(1);
            }
            return bundleId;
        }
        return type.getAncestor(2).getElementName();
    }
}

