/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.model.workspace.translationfile;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.internal.model.workspace.translationfile.AbstractTranslationFile;
import org.eclipse.scout.nls.sdk.model.workspace.translationFile.TranslationFileEvent;

public class WorkspaceTranslationFile
extends AbstractTranslationFile {
    private final IFile m_file;

    public WorkspaceTranslationFile(IFile file) {
        super(NlsCore.getLanguage(file.getName()));
        Assert.isTrue((file != null ? 1 : 0) != 0);
        Assert.isTrue((boolean)file.exists());
        this.m_file = file;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new P_TranslationFileChangedListener(), 1);
        this.reload((IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public IFile getFile() {
        return this.m_file;
    }

    @Override
    public String getName() {
        return this.m_file.getName();
    }

    @Override
    public void reload(IProgressMonitor monitor) {
        try {
            this.m_file.refreshLocal(0, monitor);
            this.parseFile(this.m_file.getContents());
        }
        catch (Exception e) {
            NlsCore.logError("cold not reload translation file: " + this.m_file.getName(), e);
        }
    }

    public void updateTextNoFire(String key, String newText, IProgressMonitor monitor) {
        this.setTranslation(key, newText, false, monitor);
    }

    @Override
    public void updateText(String key, String newText, IProgressMonitor monitor) {
        this.setTranslation(key, newText, monitor);
    }

    @Override
    public IStatus remove(String key, IProgressMonitor monitor) {
        super.setTranslation(key, null, monitor);
        return Status.OK_STATUS;
    }

    @Override
    public IStatus updateKey(String oldKey, String newKey, IProgressMonitor monitor) {
        String translation = this.getTranslation(oldKey);
        this.setTranslation(oldKey, null, monitor);
        this.setTranslation(newKey, translation, monitor);
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitChanges(IProgressMonitor monitor) {
        IFile iFile = this.m_file;
        synchronized (iFile) {
            if (!this.m_file.exists()) {
                NlsCore.logError("File: " + this.m_file.getName() + " not found!");
            }
            Properties prop = new Properties();
            Map<String, String> allTranslations = this.getAllTranslations();
            prop.putAll(allTranslations);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                prop.store(os, null);
                Object[] lines = os.toString().split(System.getProperty("line.separator"));
                int i = 0;
                if (lines.length > 0 && ((String)lines[0]).startsWith("#")) {
                    ++i;
                }
                Arrays.sort(lines);
                String NL = System.getProperty("line.separator");
                StringBuffer buffer = new StringBuffer();
                while (i < lines.length) {
                    buffer.append(String.valueOf(lines[i]) + NL);
                    ++i;
                }
                this.m_file.setContents((InputStream)new ByteArrayInputStream(buffer.toString().getBytes()), 2, monitor);
                this.m_file.refreshLocal(1, monitor);
            }
            catch (IOException iOException) {
                NlsCore.logError("could not refresh file: " + this.m_file.getName());
            }
            catch (CoreException coreException) {
                NlsCore.logError("could not refresh file: " + this.m_file.getName());
            }
        }
    }

    private class P_TranslationFileChangedListener
    implements IResourceChangeListener {
        private P_TranslationFileChangedListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) {
                            IResource resource = delta.getResource();
                            if (resource != null && resource.equals((Object)WorkspaceTranslationFile.this.m_file)) {
                                if (delta.getKind() == 2) {
                                    WorkspaceTranslationFile.this.fireTranslationFileChanged(new TranslationFileEvent(WorkspaceTranslationFile.this, 1024));
                                } else {
                                    WorkspaceTranslationFile.this.reload((IProgressMonitor)new NullProgressMonitor());
                                }
                            }
                            return true;
                        }
                    });
                }
            }
            catch (CoreException e) {
                NlsCore.logWarning(e);
            }
        }
    }
}

