/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.nls.sdk.internal.ui.fields.IInputChangedListener;
import org.eclipse.scout.nls.sdk.internal.ui.formatter.IInputFormatter;
import org.eclipse.scout.nls.sdk.internal.ui.formatter.TextInputFormatter;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ButtonTextField<T>
extends Composite {
    public static final int VALIDATE_ON_MODIFY = 8;
    public static final int VALIDATE_ON_FOCUS_LOST = 4;
    private Label m_label;
    private Text m_text;
    private Button m_smartButton;
    private IInputFormatter<T> m_inputFormatter = new TextInputFormatter();
    private List<IInputChangedListener<T>> m_inputChangedListeners = new LinkedList<IInputChangedListener<T>>();
    private String m_lastVerifiedInput;
    private T m_lastVerifiedItem = null;

    public ButtonTextField(Composite parent) {
        this(parent, 4);
    }

    public ButtonTextField(Composite parent, int style) {
        super(parent, 0);
        this.createComponent(this, style);
    }

    protected void createComponent(Composite parent, int style) {
        this.m_label = new Label(parent, 131073);
        this.m_text = new Text(parent, 2049);
        if ((style & 8) != 0) {
            this.m_text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!ButtonTextField.this.m_text.getText().equals(ButtonTextField.this.m_lastVerifiedInput)) {
                        ButtonTextField.this.handleInputChanged();
                    }
                }
            });
        } else {
            this.m_text.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (!ButtonTextField.this.m_text.getText().equals(ButtonTextField.this.m_lastVerifiedInput)) {
                        ButtonTextField.this.handleInputChanged();
                    }
                }
            });
        }
        this.m_smartButton = new Button(parent, 8);
        parent.setTabList(new Control[]{this.m_text, this.m_smartButton});
        parent.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.right = new FormAttachment(40, 0);
        this.m_label.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment((Control)this.m_label, 5);
        data.bottom = new FormAttachment(100, 0);
        data.right = new FormAttachment((Control)this.m_smartButton, -2);
        this.m_text.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.right = new FormAttachment(100, 0);
        this.m_smartButton.setLayoutData((Object)data);
    }

    private void handleInputChanged() {
        String input = this.m_text.getText();
        T item = this.m_inputFormatter.parse((Object)this, input);
        if (this.m_lastVerifiedItem == null && item == null) {
            return;
        }
        if (this.m_lastVerifiedItem != null && this.m_lastVerifiedItem.equals(item)) {
            return;
        }
        this.m_lastVerifiedItem = item;
        this.m_lastVerifiedInput = input;
        this.m_text.setText(this.m_inputFormatter.format((Object)this, item));
        for (IInputChangedListener<T> listener : this.m_inputChangedListeners) {
            listener.inputChanged(item);
        }
        this.m_text.setSelection(this.m_text.getText().length());
    }

    public void setEnabled(boolean enabled) {
        this.m_text.setEnabled(enabled);
        this.m_smartButton.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void setLabelText(String text) {
        this.m_label.setText(text);
    }

    public String getLabelText() {
        return this.m_label.getText();
    }

    public void setButtonText(String string) {
        this.m_smartButton.setText(string);
    }

    public String getButtonText() {
        return this.m_smartButton.getText();
    }

    public void setInputFormatter(IInputFormatter<T> formatter) {
        this.m_inputFormatter = formatter;
    }

    public IInputFormatter<T> getInputFormatter() {
        return this.m_inputFormatter;
    }

    public void setInput(T input) {
        this.m_text.setText(this.m_inputFormatter.format((Object)this, input));
    }

    public T getInput() {
        return this.m_inputFormatter.parse((Object)this, this.m_text.getText());
    }

    public void setTextEnabled(boolean enabled) {
        this.m_text.setEnabled(enabled);
    }

    public boolean isTextEnabled() {
        return this.m_text.isEnabled();
    }

    public boolean getTextEnabled() {
        return this.m_text.getEnabled();
    }

    public void addButtonSelectionListener(SelectionListener listener) {
        this.m_smartButton.addSelectionListener(listener);
    }

    public void removeButtonSelectionListener(SelectionListener listener) {
        this.m_smartButton.removeSelectionListener(listener);
    }

    public void addTextFocusListener(FocusListener listener) {
        this.m_text.addFocusListener(listener);
    }

    public void removeTextFocusListener(FocusListener listener) {
        this.m_text.removeFocusListener(listener);
    }

    public void addInputChangedListener(IInputChangedListener<T> listener) {
        this.m_inputChangedListeners.add(listener);
    }

    public void removeInputChangedListener(IInputChangedListener<T> listener) {
        this.m_inputChangedListeners.remove(listener);
    }

    public void setInputFire(T item) {
        this.setInput(item);
        for (IInputChangedListener<T> listener : this.m_inputChangedListeners) {
            listener.inputChanged(item);
        }
    }
}

