/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.internal.model.NlsTypeSourceFilter;
import org.eclipse.scout.nls.sdk.internal.ui.fields.IInputChangedListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class TypeChooserField
extends Composite {
    private Text m_text;
    private Hyperlink m_label;
    private Button m_button;
    private IProject[] m_projects;
    private String m_title;
    private Object m_value;
    private List<IInputChangedListener<IType>> m_inputChangedListeners = new LinkedList<IInputChangedListener<IType>>();
    private FormToolkit m_toolkit;

    public TypeChooserField(Composite parent, FormToolkit toolkit, String title) {
        super(parent, 0);
        this.m_toolkit = toolkit;
        this.m_title = title;
        this.createComponent(this);
    }

    public void addHyperlinkListner(IHyperlinkListener listener) {
        this.m_label.addHyperlinkListener(listener);
    }

    protected void createComponent(Composite parent) {
        this.m_label = this.m_toolkit.createHyperlink(parent, this.m_title, 0);
        this.m_text = new Text(parent, 2048);
        this.m_button = new Button(parent, 8);
        this.m_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TypeChooserField.this.showFileChooserDialog();
            }
        });
        this.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(40, 0);
        data.bottom = new FormAttachment(100, 0);
        this.m_label.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment((Control)this.m_label, 5);
        data.right = new FormAttachment((Control)this.m_button, -5);
        data.bottom = new FormAttachment(100, 0);
        this.m_text.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.m_button.setLayoutData((Object)data);
    }

    public void addInputChangedListneer(IInputChangedListener<IType> listener) {
        this.m_inputChangedListeners.add(listener);
    }

    public void removeInputChangedListneer(IInputChangedListener<IType> listener) {
        this.m_inputChangedListeners.remove(listener);
    }

    public void setButtonImage(Image img) {
        this.m_button.setImage(img);
    }

    public Image getButtonImage() {
        return this.m_button.getImage();
    }

    public void setButtonText(String string) {
        this.m_button.setText(string);
    }

    public String getButtonText() {
        return this.m_button.getText();
    }

    public void setLabelText(String text) {
        this.m_label.setText(text);
    }

    public String getLabelText() {
        return this.m_label.getText();
    }

    public void setType(IType input) {
        this.m_value = input;
        if (input == null) {
            this.m_text.setText("");
        } else {
            this.m_text.setText(input.getFullyQualifiedName());
        }
    }

    private void setTypeFire(IType type) {
        this.setType(type);
        for (IInputChangedListener<IType> listener : this.m_inputChangedListeners) {
            listener.inputChanged(type);
        }
    }

    public IType getType() {
        return (IType)this.m_value;
    }

    public IProject[] getProjects() {
        return this.m_projects;
    }

    public void setProjects(IProject[] projects) {
        this.m_projects = projects;
    }

    private void showFileChooserDialog() {
        try {
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)new NlsTypeSourceFilter(this.m_projects), (int)2, (boolean)false);
            dialog.setTitle(this.m_title);
            if (dialog.open() == 0) {
                Object[] result = dialog.getResult();
                this.setTypeFire((IType)result[0]);
            }
        }
        catch (JavaModelException e) {
            NlsCore.logWarning(e);
        }
    }
}

