/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeDeclarationMatch;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.internal.model.workspace.project.NlsProject;
import org.eclipse.scout.nls.sdk.internal.ui.action.NlsProposal;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.swt.graphics.Image;

public class NlsTextCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    private static final ICompletionProposal[] NO_PROPOSALS = new ICompletionProposal[0];
    private final Image m_image = NlsCore.getImage("comment");

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (!(context instanceof JavaContentAssistInvocationContext)) {
            return Collections.EMPTY_LIST;
        }
        JavaContentAssistInvocationContext javaContext = (JavaContentAssistInvocationContext)context;
        return Arrays.asList(this.computeProposals(javaContext));
    }

    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return new ArrayList();
    }

    public String getErrorMessage() {
        return "";
    }

    public void sessionStarted() {
    }

    public void sessionEnded() {
    }

    private ICompletionProposal[] computeProposals(JavaContentAssistInvocationContext context) {
        int offset = context.getInvocationOffset();
        IDocument doc = context.getDocument();
        if (doc == null || offset > doc.getLength()) {
            return null;
        }
        try {
            IRegion lineInfo = doc.getLineInformationOfOffset(offset);
            String linePart = doc.get(lineInfo.getOffset(), lineInfo.getLength());
            Matcher m = Pattern.compile("([A-Za-z0-9\\_\\-]*)\\.get\\(\\\"([a-zA-Z0-9\\_\\-]*)").matcher(linePart);
            if (m.find()) {
                String prefix = linePart.substring(m.start(2), offset - lineInfo.getOffset());
                String replacement = m.group(2);
                IType referencedType = this.getReferencedType(this.findContextType(context.getCompilationUnit(), offset), m.group(1));
                if (referencedType != null) {
                    NlsProject nlsProject = NlsCore.getNlsWorkspace().findNlsProject(referencedType, (IProgressMonitor)new NullProgressMonitor());
                    if (nlsProject == null) {
                        return NO_PROPOSALS;
                    }
                    ArrayList<NlsProposal> result = new ArrayList<NlsProposal>();
                    INlsEntry[] iNlsEntryArray = nlsProject.getEntries(prefix, false);
                    int n = iNlsEntryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        INlsEntry e = iNlsEntryArray[n2];
                        result.add(new NlsProposal(e, prefix, replacement, offset, this.m_image));
                        ++n2;
                    }
                    return result.toArray(new ICompletionProposal[result.size()]);
                }
            }
        }
        catch (Exception e) {
            NlsCore.logWarning("could not compute nls proposals.", e);
        }
        return NO_PROPOSALS;
    }

    private IType findContextType(ICompilationUnit icu, int offset) throws JavaModelException {
        IJavaElement element = icu.getElementAt(offset);
        if (element == null) {
            return null;
        }
        if (element.getElementType() == 7) {
            return (IType)element;
        }
        return (IType)element.getAncestor(7);
    }

    private IType getReferencedType(IType declaringType, String typeName) throws JavaModelException {
        String[][] resolvedTypeName;
        ICompilationUnit compilationUnit = declaringType.getCompilationUnit();
        if (compilationUnit != null) {
            IImportDeclaration[] imports;
            IImportDeclaration[] iImportDeclarationArray = imports = compilationUnit.getImports();
            int n = imports.length;
            int n2 = 0;
            while (n2 < n) {
                IType foundType;
                IImportDeclaration imp = iImportDeclarationArray[n2];
                if (imp.getElementName().endsWith("." + typeName) && (foundType = this.findType(imp.getElementName())) != null) {
                    return foundType;
                }
                ++n2;
            }
        }
        if ((resolvedTypeName = declaringType.resolveType(typeName)) != null && resolvedTypeName.length == 1) {
            IType foundType;
            String fqName = resolvedTypeName[0][0];
            if (fqName != null && fqName.length() > 0) {
                fqName = String.valueOf(fqName) + ".";
            }
            if ((foundType = this.findType(fqName = String.valueOf(fqName) + resolvedTypeName[0][1])) != null) {
                return foundType;
            }
        }
        NlsCore.logWarning("could not find referenced type '" + typeName + "' in '" + declaringType.getFullyQualifiedName() + "'.");
        return null;
    }

    private IType findType(String fqn) {
        SearchEngine searchEngine = new SearchEngine();
        final ArrayList matchList = new ArrayList();
        try {
            searchEngine.search(SearchPattern.createPattern((String)fqn, (int)0, (int)0, (int)0), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, SearchEngine.createWorkspaceScope(), new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    if (match instanceof TypeDeclarationMatch) {
                        TypeDeclarationMatch typeMatch = (TypeDeclarationMatch)match;
                        IType t = (IType)typeMatch.getElement();
                        matchList.add(t);
                    }
                }
            }, null);
            if (matchList.size() > 0) {
                return (IType)matchList.get(0);
            }
        }
        catch (CoreException e) {
            NlsCore.logWarning(e);
        }
        return null;
    }
}

