/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.action;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.internal.model.workspace.project.NlsProject;
import org.eclipse.scout.nls.sdk.internal.ui.dialog.NlsStatusDialog;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.translationFile.ITranslationFile;
import org.eclipse.scout.nls.sdk.model.workspace.util.NlsUtil;
import org.eclipse.scout.nls.sdk.util.concurrent.AbstractJob;
import org.eclipse.swt.widgets.Display;

public class RemoveAction
extends Action {
    private NlsProject m_nlsProject;
    private IStatus m_status;
    private final INlsEntry[] m_entries;

    public RemoveAction(String name, NlsProject project, INlsEntry entry) {
        this(name, project, new INlsEntry[]{entry});
    }

    public RemoveAction(String name, NlsProject project, INlsEntry[] entries) {
        super(name);
        this.m_nlsProject = project;
        this.m_entries = entries;
    }

    public void run() {
        AbstractJob job = new AbstractJob("update translation files"){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus status = null;
                ITranslationFile[] iTranslationFileArray = RemoveAction.this.m_nlsProject.getAllTranslationFiles();
                int n = iTranslationFileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITranslationFile file = iTranslationFileArray[n2];
                    INlsEntry[] iNlsEntryArray = RemoveAction.this.m_entries;
                    int n3 = iNlsEntryArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        INlsEntry e = iNlsEntryArray[n4];
                        status = file.remove(e.getKey(), monitor);
                        if (!status.isOK()) {
                            new NlsStatusDialog(Display.getDefault().getActiveShell(), status).open();
                            break;
                        }
                        ++n4;
                    }
                    ++n2;
                }
                return status;
            }
        };
        job.setUser(false);
        job.schedule();
        try {
            job.join();
            this.m_status = job.getResult();
        }
        catch (InterruptedException e) {
            NlsCore.logError("cold not remove the row key: " + NlsUtil.getVerbose(this.m_entries) + " in translation files", e);
        }
    }

    public IStatus getStatus() {
        return this.m_status;
    }
}

