/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.dialog;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NlsStatusDialog
extends StatusDialog {
    public NlsStatusDialog(Shell parent, IStatus status) {
        super(parent);
        this.updateStatus(status);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        if (this.getStatus().isMultiStatus()) {
            return this.createMultiStatusContent(parent);
        }
        Composite rootArea = new Composite(parent, 0);
        Label severityLabel = new Label(rootArea, 0);
        severityLabel.setText("Severity");
        this.attacheGridData((Control)severityLabel);
        Text severityText = new Text(rootArea, 8);
        severityText.setText(this.severityToString(this.getStatus().getSeverity()));
        this.attacheGridData((Control)severityText);
        Label messageLabel = new Label(rootArea, 0);
        messageLabel.setText("Message");
        this.attacheGridData((Control)messageLabel);
        Text message = new Text(rootArea, 8);
        String messageText = this.getStatus().getMessage();
        if (messageText == null) {
            messageText = "";
        }
        message.setText(messageText);
        this.attacheGridData((Control)message);
        rootArea.setLayout((Layout)new GridLayout(2, true));
        return rootArea;
    }

    private String severityToString(int severity) {
        switch (severity) {
            case 4: {
                return "Error";
            }
            case 2: {
                return "Warning";
            }
            case 1: {
                return "Info";
            }
            case 0: {
                return "OK";
            }
            case 8: {
                return "Cancel";
            }
        }
        return "undefined";
    }

    private Control createMultiStatusContent(Composite parent) {
        Composite rootArea = new Composite(parent, 0);
        Label l = new Label(rootArea, 0);
        l.setText("TODO multistatus handling in NlsStatusDialog");
        return rootArea;
    }

    private void attacheGridData(Control c) {
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        c.setLayoutData((Object)data);
    }
}

