/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.model.workspace.project;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.scout.nls.sdk.model.workspace.translationFile.ITranslationFile;

public class NlsFileProvider {
    private Language[] m_languageOrder;
    private HashMap<Language, ITranslationFile> m_fileMap = new HashMap();

    public NlsFileProvider() {
        this.m_languageOrder = new Language[0];
    }

    public void addFile(ITranslationFile file) {
        Language language = file.getLanguage();
        if (this.m_fileMap.containsKey(language)) {
            NlsCore.logWarning("language file already exists! filename: " + file.getName());
        } else {
            this.m_fileMap.put(language, file);
            this.m_languageOrder = this.getOrderedLanguages(this.m_fileMap.keySet());
        }
    }

    private Language[] getOrderedLanguages(Set<Language> languages) {
        TreeMap<CompositeObject, Language> orderedLanguages = new TreeMap<CompositeObject, Language>();
        for (Language l : languages) {
            int index = 3;
            if (l.equals(Language.LANGUAGE_KEY)) {
                index = 1;
            } else if (l.equals(Language.LANGUAGE_DEFAULT)) {
                index = 2;
            }
            orderedLanguages.put(new CompositeObject(new Object[]{index, l.getDispalyName()}), l);
        }
        return orderedLanguages.values().toArray(new Language[orderedLanguages.size()]);
    }

    public void remove(ITranslationFile file) {
        if (!this.m_fileMap.containsValue(file)) {
            NlsCore.logWarning("trying to remove a non existing file! filename: " + file.getName());
        } else {
            this.m_fileMap.remove(file.getLanguage());
            this.m_languageOrder = this.getOrderedLanguages(this.m_fileMap.keySet());
        }
    }

    public ITranslationFile[] getSortedFiles() {
        LinkedList<ITranslationFile> files = new LinkedList<ITranslationFile>();
        Language[] languageArray = this.m_languageOrder;
        int n = this.m_languageOrder.length;
        int n2 = 0;
        while (n2 < n) {
            Language lang = languageArray[n2];
            files.add(this.m_fileMap.get(lang));
            ++n2;
        }
        return files.toArray(new ITranslationFile[files.size()]);
    }

    public ITranslationFile[] getFiles() {
        return this.m_fileMap.values().toArray(new ITranslationFile[this.m_fileMap.size()]);
    }

    public ITranslationFile getFile(Language language) {
        return this.m_fileMap.get(language);
    }

    public boolean containsFile(Language language) {
        return this.m_fileMap.containsKey(language);
    }

    public Language[] getAllLanguages() {
        return this.m_languageOrder;
    }
}

