/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.action;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.internal.model.NlsReferenceProvider;
import org.eclipse.scout.nls.sdk.internal.model.NlsTableModel;
import org.eclipse.scout.nls.sdk.internal.search.INlsKeySearchListener;
import org.eclipse.scout.nls.sdk.internal.search.NlsFindReferencesJob;
import org.eclipse.scout.nls.sdk.internal.ui.editor.NlsTable;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.search.ui.text.Match;

public class UpdateReferenceCountAction
extends Action {
    private final INlsProject m_project;
    private final NlsTable m_table;
    private final NlsTableModel m_tableModel;
    private NlsFindReferencesJob m_job;

    public UpdateReferenceCountAction(INlsProject project, NlsTable table, NlsTableModel model) {
        this.m_project = project;
        this.m_table = table;
        this.m_tableModel = model;
        this.setText("Show nls entry usage");
        ImageDescriptor imageDescriptor = NlsCore.getImageDescriptor("updates_obj");
        this.setImageDescriptor(imageDescriptor);
    }

    public void run() {
        this.m_job = new NlsFindReferencesJob(this.m_project, this.getText());
        this.m_job.getSearchRequstor().addFindReferencesListener(new P_JobListener());
        this.m_job.schedule();
    }

    private void handleBeginSearch() {
        this.m_table.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                UpdateReferenceCountAction.this.setEnabled(false);
            }
        });
    }

    private void handleEndSearch() {
        this.m_table.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                UpdateReferenceCountAction.this.setEnabled(true);
                UpdateReferenceCountAction.this.m_tableModel.setReferenceProvider(new NlsReferenceProvider(UpdateReferenceCountAction.this.m_job.getMatches()));
                UpdateReferenceCountAction.this.m_table.refreshAll(false);
            }
        });
    }

    private class P_JobListener
    implements INlsKeySearchListener {
        private P_JobListener() {
        }

        @Override
        public void beginReporting() {
            UpdateReferenceCountAction.this.handleBeginSearch();
        }

        @Override
        public void foundMatch(String key, Match match) {
        }

        @Override
        public void endReporting() {
            UpdateReferenceCountAction.this.handleEndSearch();
        }
    }
}

