/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.dialog;

import java.util.HashMap;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.internal.ui.TextField;
import org.eclipse.scout.nls.sdk.internal.ui.fields.IInputChangedListener;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.scout.nls.sdk.model.workspace.NlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractNlsEntryDialog
extends TitleAreaDialog {
    private String m_title;
    private TextField<String> m_keyField;
    private NlsEntry m_nlsEntry;
    private INlsProject m_nlsProject;
    private HashMap<Language, TextField<String>> m_translationFields;

    public NlsEntry getNlsEntry() {
        return this.m_nlsEntry;
    }

    public INlsProject getNlsProject() {
        return this.m_nlsProject;
    }

    public AbstractNlsEntryDialog(Shell parentShell, String title, NlsEntry row, INlsProject project) {
        super(parentShell);
        this.m_nlsProject = project;
        this.m_title = title;
        this.m_nlsEntry = row;
        this.m_translationFields = new HashMap();
    }

    protected final void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.m_title);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.postCreate();
        return contents;
    }

    protected final Control createDialogArea(Composite parent) {
        Composite rootArea = new Composite(parent, 0);
        Composite inputComp = new Composite(rootArea, 0);
        this.m_keyField = new TextField(inputComp, 8, "Key Name");
        String key = this.m_nlsEntry.getKey();
        if (key == null) {
            key = "";
        }
        this.m_keyField.setValue(key);
        this.m_keyField.addInputChangedListener(new IInputChangedListener<String>(){

            @Override
            public void inputChanged(String input) {
                AbstractNlsEntryDialog.this.m_nlsEntry.setKey(input);
            }
        });
        Group translationGroup = new Group(rootArea, 0);
        Language[] languageArray = this.m_nlsProject.getAllLanguages();
        int n = languageArray.length;
        int n2 = 0;
        while (n2 < n) {
            Language l = languageArray[n2];
            TranslationField field = new TranslationField(l);
            TextField<String> control = field.create((Composite)translationGroup);
            control.setLayoutData(new GridData(768));
            field.setText(this.m_nlsEntry.getTranslation(l));
            this.m_translationFields.put(l, control);
            ++n2;
        }
        rootArea.setLayoutData((Object)new GridData(768));
        rootArea.setLayout((Layout)new GridLayout(1, true));
        GridData data = new GridData(300, -1);
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        inputComp.setLayoutData((Object)data);
        inputComp.setLayout((Layout)new GridLayout(1, true));
        data = new GridData(768);
        this.m_keyField.setLayoutData(data);
        data = new GridData(768);
        translationGroup.setLayoutData((Object)data);
        translationGroup.setLayout((Layout)new GridLayout(1, true));
        return rootArea;
    }

    public final TextField<String> getKeyField() {
        return this.m_keyField;
    }

    public NlsEntry show() {
        if (this.open() == 0) {
            return this.m_nlsEntry;
        }
        return null;
    }

    protected void postCreate() {
    }

    protected abstract void revalidate();

    protected TextField<String> getTranslationField(Language language) {
        return this.m_translationFields.get(language);
    }

    protected TextField<String> getDefaultTranslationField() {
        return this.getTranslationField(Language.LANGUAGE_DEFAULT);
    }

    protected class TranslationField {
        private TextField<String> m_input;
        private Language m_language;

        public TranslationField(Language language) {
            this.m_language = language;
        }

        public TextField<String> create(Composite parent) {
            this.m_input = new TextField(parent, 8, this.m_language.getDispalyName());
            this.m_input.addInputChangedListener(new IInputChangedListener<String>(){

                @Override
                public void inputChanged(String input) {
                    if (StringUtility.isNullOrEmpty((String)input)) {
                        AbstractNlsEntryDialog.this.m_nlsEntry.removeTranslation(TranslationField.this.m_language);
                    } else {
                        AbstractNlsEntryDialog.this.m_nlsEntry.addTranslation(TranslationField.this.m_language, input);
                    }
                }
            });
            return this.m_input;
        }

        public void setText(String text) {
            if (text == null) {
                text = "";
            }
            this.m_input.setValue(text);
        }
    }
}

