/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.dialog.language;

import java.util.Locale;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.scout.nls.sdk.internal.jdt.INlsFolder;
import org.eclipse.scout.nls.sdk.internal.model.PropertyBasedModel;
import org.eclipse.scout.nls.sdk.internal.ui.dialog.ITranslationLocationChooserModel;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;

public class TranslationFileNewModel
extends PropertyBasedModel
implements ITranslationLocationChooserModel {
    public static final String PROP_LANGUAGE_ISO = "language";
    public static final String PROP_LANGUAGE_COUNTRY_ISO = "languageCountry";
    public static final String PROP_LANGUAGE_VARIANT = "languageVariant";
    public static final String PROP_FOLDER = "location";
    public static final String PROP_PATH = "path";
    private INlsProject m_nlsProject;

    public TranslationFileNewModel(INlsProject project) {
        this.m_nlsProject = project;
        this.setPath((IPath)new Path(this.m_nlsProject.getNlsType().getTranslationsFolderName()));
    }

    @Override
    public INlsProject getNlsProject() {
        return this.m_nlsProject;
    }

    @Override
    public IProject getProject() {
        return this.m_nlsProject.getProject();
    }

    public void setLanguageIso(String isoLanguage) {
        this.setPropertyString(PROP_LANGUAGE_ISO, isoLanguage);
    }

    public String getLanguageIso() {
        return this.getPropertyString(PROP_LANGUAGE_ISO);
    }

    public void setCountryIso(String isoCountry) {
        this.setPropertyString(PROP_LANGUAGE_COUNTRY_ISO, isoCountry);
    }

    public String getCountryIso() {
        return this.getPropertyString(PROP_LANGUAGE_COUNTRY_ISO);
    }

    public void setLanguageVariant(String languageVariant) {
        this.setPropertyString(PROP_LANGUAGE_VARIANT, languageVariant);
    }

    public String getLanguageVariant() {
        return this.getPropertyString(PROP_LANGUAGE_VARIANT);
    }

    public Language getLanguage() {
        String variant;
        String langIso = this.getLanguageIso();
        if (langIso == null) {
            return null;
        }
        String countryIso = this.getCountryIso();
        if (countryIso == null) {
            countryIso = "";
        }
        if ((variant = this.getLanguageVariant()) == null) {
            variant = "";
        }
        return new Language(new Locale(langIso, countryIso, variant));
    }

    @Override
    public INlsFolder getFolder() {
        return (INlsFolder)this.getProperty(PROP_FOLDER);
    }

    public void setFolder(INlsFolder folder) {
        this.setProperty(PROP_FOLDER, folder);
    }

    public void setPath(IPath path) {
        this.setProperty(PROP_PATH, path);
    }

    @Override
    public IPath getPath() {
        return (IPath)this.getProperty(PROP_PATH);
    }
}

