/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.model.workspace.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.scout.nls.sdk.NlsCore;

public class PropertyFileReader {
    HashMap<String, String> m_parsedEntries = new HashMap();
    private final String m_fileName;

    public PropertyFileReader(InputStream stram, String fileName) {
        this.m_fileName = fileName;
        try {
            this.parsePropertyFile(stram);
        }
        catch (CoreException e) {
            NlsCore.logWarning(e);
        }
        catch (IOException e) {
            NlsCore.logWarning(e);
        }
    }

    public PropertyFileReader(IFile file) {
        this.m_fileName = file.getName();
        try {
            if (file.exists()) {
                this.parsePropertyFile(file.getContents());
            }
        }
        catch (Exception e) {
            NlsCore.logWarning(e);
        }
    }

    private void parsePropertyFile(InputStream stram) throws CoreException, IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stram));
        String line = reader.readLine();
        while (line != null) {
            if (line.startsWith("#") || line.matches("\\s*")) {
                line = reader.readLine();
                continue;
            }
            String[] args = line.split("=", 2);
            if (args.length != 2) {
                NlsCore.logWarning("could not parse property file entry '" + line + "' of file '" + this.m_fileName + "'.");
                line = reader.readLine();
                continue;
            }
            String key = args[0].trim();
            String value = args[1].trim();
            if (value.indexOf(";") > 0) {
                value = value.substring(0, value.indexOf(";"));
            }
            line = reader.readLine();
            while (line != null && line.startsWith(" ")) {
                value = String.valueOf(value) + line.trim();
                line = reader.readLine();
            }
            this.m_parsedEntries.put(key, value);
        }
    }

    public String getAttribute(String property) {
        String value = this.m_parsedEntries.get(property);
        return value;
    }
}

