/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.operations;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.internal.jdt.NlsJdtHandler;
import org.eclipse.scout.nls.sdk.internal.model.workspace.manifest.ManifestElement;
import org.eclipse.scout.nls.sdk.internal.model.workspace.manifest.ManifestEntry;
import org.eclipse.scout.nls.sdk.internal.model.workspace.manifest.WorkspaceManifestReader;
import org.eclipse.scout.nls.sdk.operations.desc.NewNlsFileOperationDesc;

public abstract class AbstractCreateNlsProjectOperation
extends Job {
    protected static final String NL = System.getProperty("line.separator");
    private static final String NLS_RUNNTIME_PLUGIN = "org.eclipse.scout.commons";
    private NewNlsFileOperationDesc m_desc;

    public AbstractCreateNlsProjectOperation(NewNlsFileOperationDesc desc) {
        super("create new Nls project...");
        this.m_desc = desc;
    }

    public final IStatus runSync() {
        return this.run((IProgressMonitor)new NullProgressMonitor());
    }

    protected final IStatus run(IProgressMonitor monitor) {
        try {
            if (!this.m_desc.getPlugin().isSynchronized(2)) {
                this.m_desc.getPlugin().refreshLocal(2, monitor);
            }
            WorkspaceManifestReader reader = new WorkspaceManifestReader(this.m_desc.getPlugin());
            ManifestEntry entry = new ManifestEntry("Require-Bundle");
            ManifestElement element = new ManifestElement(NLS_RUNNTIME_PLUGIN);
            element.addProperty("visibility:", "reexport");
            entry.addElement(element);
            reader.addElement(entry);
            for (ManifestEntry e : this.getManifestEntries()) {
                reader.addElement(e);
            }
            reader.store(monitor);
            this.createJavaClass(monitor);
            this.createDefaultMessagesFile(monitor);
            this.createNlsFile(monitor);
        }
        catch (CoreException e) {
            NlsCore.logError("could not create NLS project", e);
        }
        return Status.OK_STATUS;
    }

    protected NewNlsFileOperationDesc getDesc() {
        return this.m_desc;
    }

    protected final void createJavaClass(IProgressMonitor monitor) throws CoreException {
        IJavaProject jp = JavaCore.create((IProject)this.m_desc.getPlugin());
        IPackageFragmentRoot root = jp.findPackageFragmentRoot(this.m_desc.getSourceContainer());
        IPackageFragment fragment = root.createPackageFragment(this.m_desc.getPackage(), true, monitor);
        String className = this.m_desc.getClassName();
        if (!className.endsWith(".java")) {
            className = String.valueOf(className) + ".java";
        }
        ICompilationUnit unit = fragment.createCompilationUnit(className, "asdf", true, monitor);
        Assert.isTrue((boolean)(unit.getUnderlyingResource() instanceof IFile));
        IFile classFile = (IFile)unit.getUnderlyingResource();
        classFile.setContents((InputStream)new ByteArrayInputStream(this.getClassContent()), true, false, monitor);
    }

    protected final void createDefaultMessagesFile(IProgressMonitor monitor) throws CoreException {
        IFolder folder = this.m_desc.getPlugin().getFolder(this.m_desc.getTranslationFolder());
        NlsJdtHandler.createFolder((IContainer)folder, true, monitor);
        IFile defaultFile = folder.getFile(String.valueOf(this.m_desc.getTranlationFileName()) + ".properties");
        if (!defaultFile.exists()) {
            defaultFile.create((InputStream)new ByteArrayInputStream(this.getDefaultMessagesFileContent()), true, monitor);
        }
    }

    protected final void createNlsFile(IProgressMonitor monitor) throws CoreException {
        IFile file;
        if (this.m_desc.getPlugin() != null && !(file = this.m_desc.getPlugin().getFile(String.valueOf(this.m_desc.getFileName()) + ".nls")).exists()) {
            file.create((InputStream)new ByteArrayInputStream(this.getNlsFileContent()), true, monitor);
        }
    }

    protected abstract List<ManifestEntry> getManifestEntries();

    protected abstract byte[] getClassContent() throws JavaModelException;

    protected abstract byte[] getDefaultMessagesFileContent();

    protected byte[] getNlsFileContent() {
        StringWriter writer = new StringWriter();
        writer.append(AbstractCreateNlsProjectOperation.getNlsFileHeader());
        if (this.m_desc.isFileTypeDynamic()) {
            writer.append("Nls-Type=dynamic" + NL);
            if (this.m_desc.getParentPlugin() != null && this.m_desc.getParentFile() != null) {
                writer.append("Nls-Parent-File=" + this.m_desc.getParentPlugin().getBundleDescription().getName());
                writer.append(":" + this.m_desc.getParentFile().getName() + NL);
            }
        }
        writer.append("Nls-Class=" + this.m_desc.getPackage() + "." + this.m_desc.getClassName() + NL);
        writer.append("Nls-File-Prefix=" + this.m_desc.getTranlationFileName() + NL);
        writer.append("Nls-Translation-Folder=" + this.m_desc.getTranslationFolder() + NL);
        return writer.toString().getBytes();
    }

    public static final String getNlsFileHeader() {
        StringBuilder builder = new StringBuilder();
        builder.append("##################################################" + NL);
        builder.append("# This file is maintained by the nls editor      #" + NL);
        builder.append("# To ensure a properly working nls support of    #" + NL);
        builder.append("# keep this file untouched directly.             #" + NL);
        builder.append("##################################################" + NL);
        return builder.toString();
    }

    public static final String getTranslationFileHeader(String translationFileName) {
        StringBuilder builder = new StringBuilder();
        builder.append("##############################################################" + NL);
        builder.append("# This file is maintained by the " + translationFileName + " file and    #" + NL);
        builder.append("# should not be modified directly. Use the NLS Editor to     #" + NL);
        builder.append("# add,remove or change translations.                         #" + NL);
        builder.append("##############################################################" + NL);
        return builder.toString();
    }

    public static final String getNlsClassFileHeader(String translationFileName) {
        StringBuilder builder = new StringBuilder();
        builder.append("/**" + NL);
        builder.append(" * This class provides the nls support." + NL);
        builder.append(" * Do not change any member nor field of this class anytime otherwise the" + NL);
        builder.append(" * nls support is not anymore garanteed." + NL);
        builder.append(" * This calss is auto generated and is maintained by the plugins" + NL);
        builder.append(" * " + translationFileName + " file in the root directory of the plugin." + NL);
        builder.append(" * " + NL);
        builder.append(" * @see " + translationFileName + NL);
        builder.append(" */" + NL);
        return builder.toString();
    }
}

