/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.operations;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class TranslationHandler {
    public static final String KEY_ORIGINAL = "original";
    private HashMap<String, String[]> m_texts = new HashMap();
    private HashMap<String, Integer> m_languageIndexMapping = new HashMap();
    private String[] m_languages;

    public TranslationHandler(String[] languages) {
        this.m_languages = languages;
        int i = 0;
        while (i < languages.length) {
            this.m_languageIndexMapping.put(languages[i], new Integer(i));
            ++i;
        }
    }

    public TranslationHandler() {
    }

    public boolean add(String key, String language, String text) {
        String[] allLanguages = this.m_texts.get(key);
        if (allLanguages == null) {
            allLanguages = new String[this.m_languageIndexMapping.size()];
            this.m_texts.put(key, allLanguages);
        }
        if (allLanguages[this.getLanguageIndex(language)] != null) {
            System.err.println("Double translated word: key=" + key + " text=" + text + " language=" + language);
            return false;
        }
        allLanguages[this.getLanguageIndex((String)language)] = text;
        return true;
    }

    public HashMap<String, String> getLanguageMap(String language, String missingWordSubstitution) {
        int languageIndex = this.getLanguageIndex(language);
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String[]> entry : this.m_texts.entrySet()) {
            if (entry.getValue()[languageIndex] == null) {
                if (missingWordSubstitution == null) continue;
                map.put(entry.getKey(), missingWordSubstitution);
                continue;
            }
            map.put(entry.getKey(), entry.getValue()[languageIndex]);
        }
        return map;
    }

    public String[] getAllLanguages() {
        return this.m_languages;
    }

    public String[] getTranslations(String original) {
        return this.m_texts.get(original);
    }

    public HashMap<String, String[]> getTexts() {
        return this.m_texts;
    }

    public int getLineCount() {
        return this.m_texts.size();
    }

    public void writeCsv(OutputStream out) throws IOException {
        int separator = 59;
        out.write("key".getBytes());
        out.write(separator);
        String[] stringArray = this.m_languages;
        int n = this.m_languages.length;
        int n2 = 0;
        while (n2 < n) {
            String language = stringArray[n2];
            out.write(language.getBytes());
            out.write(separator);
            ++n2;
        }
        out.write(10);
        for (Map.Entry<String, String[]> entry : this.m_texts.entrySet()) {
            out.write(entry.getKey().getBytes());
            out.write(separator);
            String[] stringArray2 = entry.getValue();
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String text = stringArray2[n4];
                if (text != null) {
                    out.write(text.getBytes());
                }
                out.write(separator);
                ++n4;
            }
            out.write(10);
        }
    }

    public void buildUpFromStream(InputStream stream) throws IOException {
        this.cleanUp();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        try {
            String line = reader.readLine();
            if (line != null) {
                line = line.trim();
                this.parseLanguageLine(line);
                line = reader.readLine();
                while (line != null) {
                    line = line.trim();
                    this.parseCsvLine(line);
                    line = reader.readLine();
                }
            }
        }
        finally {
            reader.close();
        }
    }

    private void parseLanguageLine(String line) {
        String[] args = line.split(";");
        this.m_languages = new String[args.length - 1];
        int i = 1;
        while (i < args.length) {
            this.m_languages[i - 1] = args[i];
            this.m_languageIndexMapping.put(args[i], new Integer(i - 1));
            ++i;
        }
    }

    private boolean parseCsvLine(String line) {
        String[] args = line.split(";");
        if (args.length < this.m_languages.length + 1 && this.m_texts.get(args[0]) != null) {
            System.err.println("Doubled translated word: " + args[0]);
            return false;
        }
        String[] stringArray = this.m_languages;
        int n = this.m_languages.length;
        int n2 = 0;
        while (n2 < n) {
            String language = stringArray[n2];
            int index = this.getLanguageIndex(language) + 1;
            if (index < args.length) {
                this.add(args[0], language, args[index]);
            }
            ++n2;
        }
        return true;
    }

    private void cleanUp() {
        this.m_texts.clear();
        this.m_languages = null;
        this.m_languageIndexMapping.clear();
    }

    private int getLanguageIndex(String language) {
        return this.m_languageIndexMapping.get(language);
    }
}

