/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columnfilter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ITableColumnFilter;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

public class ComparableColumnFilter<T extends Comparable<T>>
implements ITableColumnFilter<T> {
    private final IColumn<T> m_column;
    private Set<T> m_selectedValues;
    private T m_minimumValue;
    private T m_maximumValue;

    public ComparableColumnFilter(IColumn<T> column) {
        this.m_column = column;
    }

    @Override
    public IColumn<T> getColumn() {
        return this.m_column;
    }

    @Override
    public Set<T> getSelectedValues() {
        return this.m_selectedValues;
    }

    @Override
    public void setSelectedValues(Set<T> set) {
        this.m_selectedValues = set;
    }

    public T getMinimumValue() {
        return this.m_minimumValue;
    }

    public void setMinimumValue(T minimumValue) {
        this.m_minimumValue = minimumValue;
    }

    public T getMaximumValue() {
        return this.m_maximumValue;
    }

    public void setMaximumValue(T maximumValue) {
        this.m_maximumValue = maximumValue;
    }

    @Override
    public List<LookupRow> createHistogram() {
        TreeMap<Comparable, LookupRow> hist = new TreeMap<Comparable, LookupRow>();
        HashMap<Comparable, Integer> countMap = new HashMap<Comparable, Integer>();
        ITableRow[] iTableRowArray = this.m_column.getTable().getRows();
        int n = iTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            Integer count;
            ITableRow row = iTableRowArray[n2];
            Comparable key = (Comparable)this.m_column.getValue(row);
            String text = this.m_column.getDisplayText(row);
            if (key != null && !hist.containsKey(key)) {
                FontSpec font = row.isFilterAccepted() ? null : FontSpec.parse((String)"italic");
                hist.put(key, new LookupRow((Object)key, text, null, null, null, null, font));
            }
            countMap.put(key, (count = (Integer)countMap.get(key)) != null ? count + 1 : 1);
            ++n2;
        }
        for (Map.Entry e : hist.entrySet()) {
            Integer count = (Integer)countMap.get(e.getKey());
            if (count == null || count <= 1) continue;
            LookupRow row = (LookupRow)e.getValue();
            row.setText(String.valueOf(row.getText()) + " (" + count + ")");
        }
        ArrayList<LookupRow> list = new ArrayList<LookupRow>();
        list.addAll(hist.values());
        Integer nullCount = (Integer)countMap.get(null);
        list.add(new LookupRow(null, "(" + ScoutTexts.get((String)"ColumnFilterNullText", (String[])new String[0]) + ")" + (nullCount != null && nullCount > 1 ? " (" + nullCount + ")" : "")));
        return list;
    }

    @Override
    public boolean isEmpty() {
        return (this.m_selectedValues == null || this.m_selectedValues.isEmpty()) && this.m_minimumValue == null && this.m_maximumValue == null;
    }

    @Override
    public boolean accept(ITableRow row) {
        Comparable value = (Comparable)this.m_column.getValue(row);
        if (this.m_minimumValue != null) {
            if (value == null) {
                return false;
            }
            if (value.compareTo(this.m_minimumValue) < 0) {
                return false;
            }
        }
        if (this.m_maximumValue != null) {
            if (value == null) {
                return false;
            }
            if (value.compareTo(this.m_maximumValue) > 0) {
                return false;
            }
        }
        return this.m_selectedValues == null || this.m_selectedValues.contains(value);
    }
}

