/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.smartfield;

import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractStringColumn;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.labelfield.AbstractLabelField;
import org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.AbstractRadioButtonGroup;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractSmartFieldProposalForm;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartField;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.AbstractTableField;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCallFetcher;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

public class SmartTableForm
extends AbstractSmartFieldProposalForm {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SmartTableForm.class);
    private JobEx m_dataLoadJob;
    private Object m_lastSelectedKey;

    public SmartTableForm(ISmartField<?> smartField) throws ProcessingException {
        super(smartField);
    }

    @Override
    public void forceProposalSelection() throws ProcessingException {
        MainBox.ResultTableField.Table table = (MainBox.ResultTableField.Table)this.getResultTableField().getTable();
        table.selectNextRow();
    }

    @Override
    public void update(final boolean selectCurrentValue, boolean synchronous) throws ProcessingException {
        String text = this.getSearchText();
        if (text == null) {
            text = "";
        }
        String textNonNull = text;
        final int maxCount = this.getSmartField().getBrowseMaxRowCount();
        this.getStatusField().setValue(ScoutTexts.get((String)"searchingProposals", (String[])new String[0]));
        this.getStatusField().setVisible(true);
        if (this.m_dataLoadJob != null) {
            this.m_dataLoadJob.cancel();
        }
        ILookupCallFetcher fetcher = new ILookupCallFetcher(){

            public void dataFetched(LookupRow[] rows, ProcessingException failed) {
                SmartTableForm.this.dataFetchedDelegate(rows, failed, maxCount, selectCurrentValue);
            }
        };
        if (synchronous) {
            try {
                LookupRow[] rows = "*".equals(text) ? this.getSmartField().callBrowseLookup(text, maxCount > 0 ? maxCount + 1 : 0) : (text.length() == 0 ? this.getSmartField().callBrowseLookup(text, maxCount > 0 ? maxCount + 1 : 0) : this.getSmartField().callTextLookup(text, maxCount > 0 ? maxCount + 1 : 0));
                fetcher.dataFetched(rows, null);
            }
            catch (ProcessingException e) {
                fetcher.dataFetched(null, e);
            }
        } else {
            this.m_dataLoadJob = "*".equals(textNonNull) ? this.getSmartField().callBrowseLookupInBackground(textNonNull, maxCount > 0 ? maxCount + 1 : 0, fetcher) : (textNonNull.length() == 0 ? this.getSmartField().callBrowseLookupInBackground(textNonNull, maxCount > 0 ? maxCount + 1 : 0, fetcher) : this.getSmartField().callTextLookupInBackground(textNonNull, maxCount > 0 ? maxCount + 1 : 0, fetcher));
        }
    }

    private void dataFetchedDelegate(LookupRow[] rows, ProcessingException failed, int maxCount, boolean selectCurrentValue) {
        try {
            MainBox.ResultTableField.Table table;
            block19: {
                table = (MainBox.ResultTableField.Table)this.getResultTableField().getTable();
                if (rows == null) {
                    rows = new LookupRow[]{};
                }
                int n = rows.length;
                if (maxCount > 0) {
                    n = Math.min(n, maxCount);
                }
                ITableRow[] tableRows = new ITableRow[n];
                int i = 0;
                while (i < n) {
                    Object[] objectArray = new Object[2];
                    objectArray[0] = rows[i];
                    tableRows[i] = table.createRow(objectArray);
                    tableRows[i].setEnabled(rows[i].isEnabled());
                    ++i;
                }
                try {
                    table.setTableChanging(true);
                    table.discardAllRows();
                    table.addRows(tableRows);
                    Object keyToSelect = null;
                    if (selectCurrentValue) {
                        keyToSelect = this.m_lastSelectedKey = this.getSmartField().getValue();
                    } else if (table.getRowCount() == 1 && !this.getSmartField().isAllowCustomText()) {
                        keyToSelect = ((LookupRow)table.getKeyColumn().getValue(0)).getKey();
                    }
                    if (keyToSelect == null) break block19;
                    ITableRow[] iTableRowArray = table.getRows();
                    int n2 = iTableRowArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        ITableRow row = iTableRowArray[n3];
                        if (CompareUtility.equals((Object)keyToSelect, (Object)((LookupRow)table.getKeyColumn().getValue(row)).getKey())) {
                            table.selectRow(row);
                            break;
                        }
                        ++n3;
                    }
                }
                finally {
                    table.setTableChanging(false);
                }
            }
            String statusText = null;
            if (failed != null) {
                statusText = failed.getStatus().getMessage();
            } else if (rows.length <= 0) {
                statusText = ScoutTexts.get((String)"SmartFieldCannotComplete", (String[])new String[]{this.getSearchText()});
            } else if (rows.length > this.getSmartField().getBrowseMaxRowCount()) {
                statusText = ScoutTexts.get((String)"SmartFieldMoreThanXRows", (String[])new String[]{"" + this.getSmartField().getBrowseMaxRowCount()});
            }
            this.getStatusField().setValue(statusText);
            this.getStatusField().setVisible(statusText != null);
            if (this.getNewButton().isEnabled()) {
                this.getNewButton().setVisible(table.getRowCount() <= 0);
            }
            this.structureChanged(this.getResultTableField());
        }
        catch (ProcessingException e) {
            LOG.warn("update proposal list", (Throwable)e);
        }
    }

    @ConfigOperation
    @Order(value=120.0)
    protected LookupRow execGetSingleMatch() {
        int matchCount = 0;
        LookupRow foundRow = null;
        LookupRow[] lookupRowArray = (LookupRow[])((MainBox.ResultTableField.Table)this.getResultTableField().getTable()).getKeyColumn().getValues();
        int n = lookupRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            LookupRow row = lookupRowArray[n2];
            if (row.isEnabled()) {
                foundRow = row;
                ++matchCount;
            }
            ++n2;
        }
        if (matchCount == 1) {
            return foundRow;
        }
        return null;
    }

    @Override
    public LookupRow getAcceptedProposal() throws ProcessingException {
        LookupRow row = (LookupRow)((MainBox.ResultTableField.Table)this.getResultTableField().getTable()).getKeyColumn().getSelectedValue();
        if (row != null && row.isEnabled()) {
            return row;
        }
        if (this.getSmartField().isAllowCustomText()) {
            return null;
        }
        return this.execGetSingleMatch();
    }

    @Override
    public void startForm() throws ProcessingException {
        this.startInternal(new FormHandler());
    }

    public MainBox getMainBox() {
        return (MainBox)this.getRootGroupBox();
    }

    public MainBox.ResultTableField getResultTableField() {
        return this.getFieldByClass(MainBox.ResultTableField.class);
    }

    public MainBox.ActiveStateRadioButtonGroup getActiveStateRadioButtonGroup() {
        return this.getFieldByClass(MainBox.ActiveStateRadioButtonGroup.class);
    }

    public MainBox.StatusField getStatusField() {
        return this.getFieldByClass(MainBox.StatusField.class);
    }

    public MainBox.NewButton getNewButton() {
        return this.getFieldByClass(MainBox.NewButton.class);
    }

    private class FormHandler
    extends AbstractFormHandler {
        private FormHandler() {
        }

        @Override
        protected void execLoad() throws ProcessingException {
            ((MainBox.ResultTableField.Table)SmartTableForm.this.getResultTableField().getTable()).setDefaultIconId(SmartTableForm.this.getSmartField().getBrowseIconId());
            SmartTableForm.this.getActiveStateRadioButtonGroup().setVisible(SmartTableForm.this.getSmartField().isActiveFilterEnabled());
            SmartTableForm.this.getActiveStateRadioButtonGroup().setValue(SmartTableForm.this.getSmartField().getActiveFilter());
            SmartTableForm.this.getNewButton().setEnabled(SmartTableForm.this.getSmartField().getBrowseNewText() != null);
            SmartTableForm.this.getNewButton().setLabel(SmartTableForm.this.getSmartField().getBrowseNewText());
        }

        @Override
        protected boolean execValidate() throws ProcessingException {
            return SmartTableForm.this.getAcceptedProposal() != null;
        }

        @Override
        protected void execFinally() throws ProcessingException {
            if (SmartTableForm.this.m_dataLoadJob != null) {
                SmartTableForm.this.m_dataLoadJob.cancel();
            }
        }
    }

    public class MainBox
    extends AbstractGroupBox {
        @Override
        protected boolean getConfiguredBorderVisible() {
            return false;
        }

        @Override
        protected int getConfiguredGridColumnCount() {
            return 1;
        }

        @Override
        protected boolean getConfiguredGridUseUiWidth() {
            return true;
        }

        @Override
        protected boolean getConfiguredGridUseUiHeight() {
            return true;
        }

        @Order(value=30.0)
        public class ActiveStateRadioButtonGroup
        extends AbstractRadioButtonGroup<TriState> {
            @Override
            protected boolean getConfiguredLabelVisible() {
                return false;
            }

            @Override
            protected void execChangedValue() throws ProcessingException {
                if (this.isVisible() && !SmartTableForm.this.isFormLoading()) {
                    SmartTableForm.this.getSmartField().setActiveFilter((TriState)this.getValue());
                    SmartTableForm.this.update(false, false);
                }
            }

            @Order(value=30.0)
            public class ActiveAndInactiveButton
            extends AbstractButton {
                @Override
                protected int getConfiguredDisplayStyle() {
                    return 2;
                }

                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"ActiveAndInactiveStates", (String[])new String[0]);
                }

                @Override
                protected Object getConfiguredRadioValue() {
                    return TriState.UNDEFINED;
                }
            }

            @Order(value=10.0)
            public class ActiveButton
            extends AbstractButton {
                @Override
                protected int getConfiguredDisplayStyle() {
                    return 2;
                }

                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"ActiveStates", (String[])new String[0]);
                }

                @Override
                protected Object getConfiguredRadioValue() {
                    return TriState.TRUE;
                }
            }

            @Order(value=20.0)
            public class InactiveButton
            extends AbstractButton {
                @Override
                protected int getConfiguredDisplayStyle() {
                    return 2;
                }

                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"InactiveStates", (String[])new String[0]);
                }

                @Override
                protected Object getConfiguredRadioValue() {
                    return TriState.FALSE;
                }
            }
        }

        @Order(value=40.0)
        public class NewButton
        extends AbstractButton {
            @Override
            protected boolean getConfiguredLabelVisible() {
                return false;
            }

            @Override
            protected boolean getConfiguredVisible() {
                return false;
            }

            @Override
            protected boolean getConfiguredEnabled() {
                return false;
            }

            @Override
            protected boolean getConfiguredFillHorizontal() {
                return false;
            }

            @Override
            protected int getConfiguredDisplayStyle() {
                return 3;
            }

            @Override
            protected boolean getConfiguredProcessButton() {
                return false;
            }

            @Override
            protected void execClickAction() throws ProcessingException {
                SmartTableForm.this.getSmartField().doBrowseNew(SmartTableForm.this.getSearchText());
            }
        }

        @Order(value=10.0)
        public class ResultTableField
        extends AbstractTableField<Table> {
            @Override
            protected boolean getConfiguredLabelVisible() {
                return false;
            }

            @Override
            protected double getConfiguredGridWeightY() {
                return 1.0;
            }

            @Override
            protected boolean getConfiguredGridUseUiWidth() {
                return true;
            }

            @Override
            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }

            @Order(value=4.0)
            public class Table
            extends AbstractTable {
                @Override
                protected boolean getConfiguredAutoResizeColumns() {
                    return true;
                }

                @Override
                protected boolean getConfiguredHeaderVisible() {
                    return false;
                }

                @Override
                protected boolean getConfiguredMultiSelect() {
                    return false;
                }

                @Override
                protected boolean getConfiguredScrollToSelection() {
                    return true;
                }

                @Override
                protected void execRowClick(ITableRow row) throws ProcessingException {
                    LookupRow lrow = (LookupRow)this.getKeyColumn().getSelectedValue();
                    if (lrow != null && lrow.isEnabled()) {
                        SmartTableForm.this.doOk();
                    }
                }

                public KeyColumn getKeyColumn() {
                    return this.getColumnSet().getColumnByClass(KeyColumn.class);
                }

                public TextColumn getTextColumn() {
                    return this.getColumnSet().getColumnByClass(TextColumn.class);
                }

                @Order(value=1.0)
                public class KeyColumn
                extends AbstractColumn<LookupRow> {
                    @Override
                    protected boolean getConfiguredPrimaryKey() {
                        return true;
                    }

                    @Override
                    protected boolean getConfiguredDisplayable() {
                        return false;
                    }
                }

                @Order(value=2.0)
                public class TextColumn
                extends AbstractStringColumn {
                    @Override
                    protected void execDecorateCell(Cell cell, ITableRow row) {
                        LookupRow lookupRow = (LookupRow)Table.this.getKeyColumn().getValue(row);
                        cell.setText(lookupRow.getText());
                        cell.setTooltipText(lookupRow.getTooltipText());
                        cell.setBackgroundColor(lookupRow.getBackgroundColor());
                        cell.setForegroundColor(lookupRow.getForegroundColor());
                        cell.setFont(lookupRow.getFont());
                        if (((Table)SmartTableForm.this.getResultTableField().getTable()).getDefaultIconId() == null && lookupRow.getIconId() != null) {
                            cell.setIconId(lookupRow.getIconId());
                        }
                    }
                }
            }
        }

        @Order(value=50.0)
        public class StatusField
        extends AbstractLabelField {
            @Override
            protected boolean getConfiguredLabelVisible() {
                return false;
            }

            @Override
            protected int getConfiguredGridH() {
                return 1;
            }

            @Override
            protected String getConfiguredForegroundColor() {
                return "FF0000";
            }

            @Override
            protected double getConfiguredGridWeightY() {
                return 0.0;
            }
        }
    }
}

