/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.nls.editor;

import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.scout.sdk.core.s.nls.ITranslationEntry;
import org.eclipse.scout.sdk.core.s.nls.ITranslationStore;
import org.eclipse.scout.sdk.core.s.nls.Language;
import org.eclipse.scout.sdk.core.s.nls.TranslationValidator;
import org.eclipse.scout.sdk.core.util.EventListenerList;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.TranslationInputValidator;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.editor.NlsTableCell;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.editor.NlsTableController;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.editor.TableTextEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class NlsTableCursor {
    private static final Pattern TEXT_EDIT_BEGIN_PAT = Pattern.compile("[a-zA-Z0-9]");
    private static final String COLOR_FOREGROUND = "scout.color_table_cursor_foreground";
    private static final String COLOR_FOREGROUND_INACTIVE = "scout.color_table_cursor_inactive_foreground";
    private static final String COLOR_BACKGROUND = "scout.color_table_cursor_background";
    private static final String COLOR_BACKGROUND_INACTIVE = "scout.color_table_cursor_inactive_background";
    private final TableCursor m_cursor;
    private final EventListenerList m_listeners;
    private final Map<String, RGB> m_colors;
    private final NlsTableController m_controller;
    private boolean m_renaming;
    private TableTextEditor m_editingText;

    public NlsTableCursor(Table parent, NlsTableController controller) {
        this.m_controller = controller;
        this.m_cursor = new TableCursor(parent, 0);
        this.m_cursor.setBackgroundMode(2);
        this.m_listeners = new EventListenerList();
        this.m_colors = new HashMap<String, RGB>(4);
        this.m_colors.put(COLOR_FOREGROUND, new RGB(255, 255, 255));
        this.m_colors.put(COLOR_BACKGROUND, new RGB(13, 58, 161));
        this.m_colors.put(COLOR_BACKGROUND_INACTIVE, new RGB(255, 255, 255));
        this.m_colors.put(COLOR_FOREGROUND_INACTIVE, new RGB(0, 0, 0));
        this.m_cursor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                NlsTableCursor.this.getCursor().setForeground(NlsTableCursor.this.getColor(NlsTableCursor.COLOR_FOREGROUND));
                NlsTableCursor.this.getCursor().setBackground(NlsTableCursor.this.getColor(NlsTableCursor.COLOR_BACKGROUND));
            }

            public void focusLost(FocusEvent e) {
                NlsTableCursor.this.getCursor().setBackground(NlsTableCursor.this.getColor(NlsTableCursor.COLOR_BACKGROUND_INACTIVE));
                NlsTableCursor.this.getCursor().setForeground(NlsTableCursor.this.getColor(NlsTableCursor.COLOR_FOREGROUND_INACTIVE));
            }
        });
        this.m_cursor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                NlsTableCursor.this.createEditableText();
            }
        });
        this.m_cursor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.stateMask) {
                    case 65536: 
                    case 262144: {
                        return;
                    }
                }
                if (e.keyCode == 0x100000B) {
                    NlsTableCursor.this.createEditableText();
                } else {
                    String input = new String(new char[]{e.character});
                    if (NlsTableCursor.this.getCursor().getColumn() > 0 && TEXT_EDIT_BEGIN_PAT.matcher(input).matches()) {
                        NlsTableCursor.this.createEditableText(String.valueOf(e.character));
                    }
                }
            }
        });
        this.m_cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem row = ((TableCursor)e.getSource()).getRow();
                ITranslationEntry entry = NlsTableController.entryOfRow(row);
                if (entry == null) {
                    return;
                }
                if (entry.store().isEditable()) {
                    NlsTableCursor.this.getCursor().setForeground(NlsTableCursor.this.getColor(NlsTableCursor.COLOR_FOREGROUND));
                    NlsTableCursor.this.getCursor().setBackground(NlsTableCursor.this.getColor(NlsTableCursor.COLOR_BACKGROUND));
                } else {
                    NlsTableCursor.this.getCursor().setForeground(NlsTableCursor.this.getColor(NlsTableCursor.COLOR_FOREGROUND_INACTIVE));
                    NlsTableCursor.this.getCursor().setBackground(NlsTableCursor.this.getColor(NlsTableCursor.COLOR_BACKGROUND_INACTIVE));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                NlsTableCursor.this.createEditableText();
            }
        });
    }

    public Optional<NlsTableCell> getSelection() {
        TableItem row = this.getCursor().getRow();
        if (row == null) {
            return Optional.empty();
        }
        int column = this.getCursor().getColumn();
        Language lang = this.m_controller.languageOfColumn(column);
        return Optional.of(new NlsTableCell(column, NlsTableController.entryOfRow(row), lang));
    }

    public void setVisible(boolean visible) {
        this.getCursor().setVisible(visible);
    }

    public void addKeyListener(KeyListener listener) {
        this.getCursor().addKeyListener(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.getCursor().removeKeyListener(listener);
    }

    public void addCursorListener(INlsTableCursorListener listener) {
        this.m_listeners.add((EventListener)listener);
    }

    public void removeCursorListener(INlsTableCursorListener listener) {
        this.m_listeners.remove((EventListener)listener);
    }

    public void ensureFocus(TableItem row, int column) {
        this.getCursor().setSelection(row, column);
        this.getCursor().setVisible(true);
        this.getCursor().setFocus();
    }

    public void setEditableText(int rowIndex, int column) {
        this.getCursor().setSelection(rowIndex, column);
        this.createEditableText();
    }

    private Color getColor(String id) {
        RGB rgb;
        ColorRegistry colorRegistry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        if (!colorRegistry.hasValueFor(id) && (rgb = this.m_colors.get(id)) != null) {
            colorRegistry.put(id, rgb);
        }
        return colorRegistry.get(id);
    }

    public void createEditableText() {
        this.createEditableText(null);
    }

    private void createEditableText(String input) {
        Optional<NlsTableCell> selection = this.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        NlsTableCell cell = selection.get();
        if (!cell.store().isEditable()) {
            return;
        }
        if (cell.column() == 0) {
            return;
        }
        this.createEditableTextInternal(input);
    }

    private IStatus validateEditingText() {
        int selectedColumn = this.getCursor().getColumn();
        if (selectedColumn == 1) {
            ITranslationStore storeOfSelectedRow = this.getSelection().get().store();
            return TranslationInputValidator.validateNlsKey(this.m_controller.stack(), storeOfSelectedRow, this.m_editingText.getText());
        }
        return Status.OK_STATUS;
    }

    private String getEditableTextContent(String inputText, boolean isKeyColumn) {
        if (inputText == null) {
            if (isKeyColumn) {
                return NlsTableController.entryOfRow(this.getCursor().getRow()).key();
            }
            Language lang = this.m_controller.languageOfColumn(this.getCursor().getColumn());
            return NlsTableController.entryOfRow(this.getCursor().getRow()).text(lang).orElse("");
        }
        return inputText;
    }

    private void createEditableTextInternal(String defaultText) {
        if (this.m_editingText != null && !this.m_editingText.isDisposed()) {
            this.m_editingText.dispose();
        }
        boolean isKeyColumn = this.getCursor().getColumn() == 1;
        String input = this.getEditableTextContent(defaultText, isKeyColumn);
        this.m_editingText = new TableTextEditor((Control)this.getCursor(), isKeyColumn ? 0 : 770);
        this.m_editingText.setText(input);
        this.m_editingText.addModifyListener(e -> {
            if (TranslationValidator.isForbidden((int)this.validateEditingText().getCode())) {
                this.m_editingText.setForeground(this.m_editingText.getDisplay().getSystemColor(3));
            } else {
                this.m_editingText.setForeground(null);
            }
        });
        if (defaultText != null) {
            this.m_editingText.setSelection(input.length());
        } else {
            this.m_editingText.setSelection(0, input.length());
        }
        this.m_editingText.addKeyListener((KeyListener)new KeyAdapter(){
            private boolean m_altPressed;

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 65536) {
                    this.m_altPressed = false;
                }
            }

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 27: {
                        NlsTableCursor.this.disposeText();
                        break;
                    }
                    case 65536: {
                        this.m_altPressed = true;
                        break;
                    }
                    case 13: {
                        if (this.m_altPressed) {
                            if (NlsTableCursor.this.getCursor().getColumn() == 1) break;
                            this.addNewLine();
                            break;
                        }
                        NlsTableCursor.this.storeText();
                    }
                }
            }

            private void addNewLine() {
                if (NlsTableCursor.this.m_editingText == null || NlsTableCursor.this.m_editingText.isDisposed()) {
                    return;
                }
                NlsTableCursor.this.m_editingText.insertText("\n");
            }
        });
        this.m_editingText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (NlsTableCursor.this.m_renaming) {
                    return;
                }
                NlsTableCursor.this.storeText();
            }
        });
        this.m_editingText.open();
        this.m_editingText.setFocus();
    }

    private void disposeText() {
        this.m_editingText.dispose();
        this.m_editingText = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeText() {
        if (this.m_editingText == null || this.m_editingText.isDisposed()) {
            return;
        }
        if (TranslationValidator.isForbidden((int)this.validateEditingText().getCode())) {
            this.disposeText();
            return;
        }
        this.m_renaming = true;
        try {
            String text = this.m_editingText.getText();
            NlsTableCell selection = this.getSelection().get();
            for (INlsTableCursorListener listener : this.m_listeners.get(INlsTableCursorListener.class)) {
                listener.textStored(selection, text);
            }
        }
        finally {
            this.disposeText();
            this.m_renaming = false;
        }
    }

    public TableCursor getCursor() {
        return this.m_cursor;
    }

    @FunctionalInterface
    public static interface INlsTableCursorListener
    extends EventListener {
        public void textStored(NlsTableCell var1, String var2);
    }
}

