/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.nls;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.scout.sdk.core.s.nls.ITranslation;
import org.eclipse.scout.sdk.core.s.nls.ITranslationStore;
import org.eclipse.scout.sdk.core.s.nls.Language;
import org.eclipse.scout.sdk.core.s.nls.Translation;
import org.eclipse.scout.sdk.core.s.nls.TranslationStoreStack;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.ui.fields.FieldToolkit;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.s2e.ui.fields.text.TextField;
import org.eclipse.scout.sdk.s2e.ui.internal.S2ESdkUiActivator;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.action.CopyPasteAction;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractTranslationDialog
extends TitleAreaDialog {
    protected static final String DIALOG_SETTINGS_WIDTH = "dialogSettingsWidth";
    protected static final String DIALOG_SETTINGS_HEIGHT = "dialogSettingsHeight";
    protected static final String DIALOG_SETTINGS_X = "dialogSettingsX";
    protected static final String DIALOG_SETTINGS_Y = "dialogSettingsY";
    private final Translation m_nlsEntry;
    private final TranslationStoreStack m_nlsProject;
    private final boolean m_showProjectList;
    private final String m_title;
    private final Map<Language, TextField> m_translationFields;
    private final Display m_display;
    private boolean m_keyToClipboard;
    private ITranslationStore m_store;
    private TextField m_keyField;
    private ProposalTextField m_projectProposalField;
    private Composite m_fixDialogArea;
    private Button m_copyKeyToClipboard;

    protected AbstractTranslationDialog(Shell parentShell, String title, ITranslation row, TranslationStoreStack project, boolean showProjectList) {
        super(parentShell);
        this.m_display = parentShell.getDisplay();
        this.m_nlsProject = (TranslationStoreStack)Ensure.notNull((Object)project);
        this.m_title = (String)Ensure.notNull((Object)title);
        this.m_nlsEntry = new Translation(row);
        this.m_store = project.primaryEditableStore().orElse(null);
        this.m_translationFields = new HashMap<Language, TextField>();
        this.m_showProjectList = showProjectList && project.allEditableStores().count() > 1L;
    }

    protected final void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.m_title);
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return S2ESdkUiActivator.getDefault().getDialogSettingsSection(AbstractTranslationDialog.class.getName() + ".dialogBounds");
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.m_title);
        this.postCreate();
        this.getButton(0).setText("&Ok");
        TextField defaultTranslationField = this.getDefaultTranslationField();
        if (defaultTranslationField != null) {
            defaultTranslationField.setFocus();
        }
        contents.setEnabled(this.getNlsProject().isEditable());
        this.setTitleImage(S2ESdkUiActivator.getImage("newscoutprj_wiz.png"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.scout.sdk.s2e.ui.scout_wizard_nls-entry_page_context");
        this.setHelpAvailable(true);
        return contents;
    }

    protected void reCreateDialogArea() {
        for (Control c : this.m_fixDialogArea.getChildren()) {
            c.dispose();
        }
        this.createDialogArea(null);
        this.postCreate();
        this.m_fixDialogArea.layout(true, true);
        this.m_fixDialogArea.getParent().redraw();
    }

    protected final Control createDialogArea(Composite parent) {
        if (this.m_fixDialogArea == null) {
            this.m_fixDialogArea = new Composite(parent, 0);
            GridLayoutFactory.swtDefaults().applyTo(this.m_fixDialogArea);
            GridDataFactory.defaultsFor((Control)this.m_fixDialogArea).align(4, 4).grab(true, true).applyTo((Control)this.m_fixDialogArea);
        }
        Composite rootArea = new Composite(this.m_fixDialogArea, 0);
        Composite inputComp = new Composite(rootArea, 0);
        this.m_projectProposalField = FieldToolkit.createTranslationStoreProposalField(inputComp, "Create in", this.getNlsProject(), 60);
        this.m_projectProposalField.acceptProposal(this.getSelectedStore().orElse(null));
        this.m_projectProposalField.addProposalListener(item -> {
            if (this.getSelectedStore().orElse(null) == item) {
                return;
            }
            this.setSelectedStore((ITranslationStore)item);
            this.reCreateDialogArea();
        });
        this.m_projectProposalField.setVisible(this.isShowProjectList());
        this.m_keyField = new TextField(inputComp, 1, 60);
        this.m_keyField.setLabelText("Key Name");
        this.m_keyField.setText(this.m_nlsEntry.key());
        this.m_keyField.addModifyListener(input -> this.m_nlsEntry.setKey(this.m_keyField.getText()));
        final TabFolder translationGroup = new TabFolder(rootArea, 0);
        translationGroup.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                translationGroup.getItem(translationGroup.getSelectionIndex()).getControl().setFocus();
            }
        });
        Set languages = this.getSelectedStore().map(ITranslationStore::languages).orElseGet(Stream::empty).collect(Collectors.toCollection(TreeSet::new));
        this.m_translationFields.clear();
        for (Language l : languages) {
            Composite txtFieldContainer = new Composite((Composite)translationGroup, 0);
            TabItem tabItem = new TabItem(translationGroup, 0);
            tabItem.setText(l.displayName());
            tabItem.setControl((Control)txtFieldContainer);
            GridDataFactory.defaultsFor((Control)txtFieldContainer).align(4, 4).grab(true, true).minSize(0, 80).applyTo((Control)txtFieldContainer);
            GridLayoutFactory.swtDefaults().margins(4, 4).applyTo(txtFieldContainer);
            TextField field = this.createTranslationField(txtFieldContainer, l);
            field.setText(this.m_nlsEntry.text(l).orElse(""));
            field.setSelection(field.getText().length());
            GridDataFactory.defaultsFor((Control)field).align(4, 4).grab(true, true).applyTo((Control)field);
            this.m_translationFields.put(l, field);
        }
        this.m_copyKeyToClipboard = new Button(rootArea, 32);
        this.m_copyKeyToClipboard.setText("Copy key to clipboard");
        this.m_copyKeyToClipboard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractTranslationDialog.this.m_keyToClipboard = AbstractTranslationDialog.this.m_copyKeyToClipboard.getSelection();
            }
        });
        GridDataFactory.defaultsFor((Control)rootArea).align(4, 4).grab(true, true).applyTo((Control)rootArea);
        GridLayoutFactory.swtDefaults().applyTo(rootArea);
        GridDataFactory.defaultsFor((Control)this.m_projectProposalField).align(4, 0x1000000).exclude(!this.isShowProjectList()).applyTo((Control)this.m_projectProposalField);
        GridLayoutFactory.swtDefaults().applyTo(inputComp);
        GridDataFactory.defaultsFor((Control)inputComp).hint(300, -1).grab(true, false).align(4, 0x1000000).applyTo((Control)inputComp);
        GridDataFactory.defaultsFor((Control)this.m_keyField).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_keyField);
        GridDataFactory.defaultsFor((Control)translationGroup).align(4, 4).hint(600, 100).grab(true, true).applyTo((Control)translationGroup);
        GridLayoutFactory.swtDefaults().applyTo((Composite)translationGroup);
        GridDataFactory.defaultsFor((Control)this.m_copyKeyToClipboard).align(4, 0x1000000).applyTo((Control)this.m_copyKeyToClipboard);
        return this.m_fixDialogArea;
    }

    protected TextField createTranslationField(Composite parent, Language l) {
        final TextField translationField = new TextField(parent, 8);
        translationField.addModifyListener(event -> {
            String newText = translationField.getText();
            if (Strings.isEmpty((CharSequence)newText)) {
                this.m_nlsEntry.putText(l, null);
            } else {
                this.m_nlsEntry.putText(l, newText);
            }
        });
        translationField.addModifyListener(new ModifyListener(){
            private String m_oldInput;

            public void modifyText(ModifyEvent event) {
                String newText = translationField.getText();
                if (AbstractTranslationDialog.this.getKeyField().isEnabled() && !Strings.isEmpty((CharSequence)newText)) {
                    String oldKey = AbstractTranslationDialog.this.getNlsProject().generateNewKey(this.m_oldInput);
                    String curVal = AbstractTranslationDialog.this.getKeyField().getText();
                    if (Strings.isBlank((CharSequence)curVal)) {
                        curVal = null;
                    }
                    if (curVal == null || Objects.equals(curVal, oldKey)) {
                        AbstractTranslationDialog.this.m_keyField.setText(AbstractTranslationDialog.this.getNlsProject().generateNewKey(newText));
                    }
                }
                this.m_oldInput = newText;
            }
        });
        return translationField;
    }

    protected final TextField getKeyField() {
        return this.m_keyField;
    }

    protected final ProposalTextField getProjectProposalField() {
        return this.m_projectProposalField;
    }

    public Optional<ITranslation> show() {
        if (this.open() == 0) {
            if (this.m_keyToClipboard) {
                this.copyKeyToClipboard();
            }
            return Optional.ofNullable(this.m_nlsEntry);
        }
        return Optional.empty();
    }

    private void copyKeyToClipboard() {
        ITranslation entry = this.getNlsEntry();
        if (entry == null) {
            return;
        }
        String key = entry.key();
        if (Strings.isBlank((CharSequence)key)) {
            return;
        }
        new CopyPasteAction("empty", key, this.m_display).run();
    }

    protected void postCreate() {
    }

    protected abstract void revalidate();

    protected TextField getTranslationField(Language language) {
        return this.m_translationFields.get(language);
    }

    protected TextField getDefaultTranslationField() {
        return this.getTranslationField(Language.LANGUAGE_DEFAULT);
    }

    public void setMessage(IStatus status) {
        int sev;
        switch (status.getSeverity()) {
            case 4: {
                sev = 3;
                break;
            }
            case 2: {
                sev = 2;
                break;
            }
            case 1: {
                sev = 1;
                break;
            }
            default: {
                sev = 0;
            }
        }
        this.setMessage(status.getMessage(), sev);
    }

    public ITranslation getNlsEntry() {
        return this.m_nlsEntry;
    }

    public Optional<ITranslationStore> getSelectedStore() {
        return Optional.ofNullable(this.m_store);
    }

    public void setSelectedStore(ITranslationStore store) {
        this.m_store = store;
    }

    public TranslationStoreStack getNlsProject() {
        return this.m_nlsProject;
    }

    private boolean isShowProjectList() {
        return this.m_showProjectList;
    }
}

