/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.model.api.Flags;
import org.eclipse.scout.sdk.core.util.JavaTypes;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.Strings;

public final class JdtUtils {
    private static final Comparator<IType> COMPARATOR = new P_TypeMatchComparator();

    private JdtUtils() {
    }

    public static IPackageFragmentRoot getSourceFolder(IJavaElement e) {
        if (e == null) {
            return null;
        }
        return (IPackageFragmentRoot)e.getAncestor(3);
    }

    public static String getPackage(ICompilationUnit icu) {
        if (!JdtUtils.exists((IJavaElement)icu)) {
            return "";
        }
        try {
            IPackageDeclaration[] packageDeclarations = icu.getPackageDeclarations();
            if (packageDeclarations.length < 1) {
                return "";
            }
            return packageDeclarations[0].getElementName();
        }
        catch (JavaModelException e) {
            throw new SdkException((Throwable)e);
        }
    }

    public static Set<IType> findAbstractClassesInHierarchy(IJavaProject sourceProject, String baseTypeFqn, IProgressMonitor monitor) {
        return JdtUtils.findTypesInStrictHierarchy(sourceProject, baseTypeFqn, monitor, (Predicate<IType>)new PublicAbstractPrimaryTypeFilter());
    }

    public static Set<IType> findTypesInStrictHierarchy(IJavaProject sourceProject, String baseTypeFqn, IProgressMonitor monitor, Predicate<IType> filter) {
        if (!JdtUtils.exists((IJavaElement)sourceProject)) {
            return Collections.emptySet();
        }
        try {
            IType t = sourceProject.findType(baseTypeFqn.replace('$', '.'), monitor);
            return JdtUtils.findTypesInStrictHierarchy(sourceProject, t, monitor, filter);
        }
        catch (JavaModelException e) {
            throw new SdkException((Throwable)e);
        }
    }

    public static Set<IType> findTypesInStrictHierarchy(IJavaProject sourceProject, IType baseType, IProgressMonitor monitor, Predicate<IType> filter) {
        if (!(JdtUtils.exists((IJavaElement)baseType) && JdtUtils.exists(baseType.getParent()) && JdtUtils.exists((IJavaElement)sourceProject))) {
            return Collections.emptySet();
        }
        try {
            ITypeHierarchy hierarchy = baseType.newTypeHierarchy(sourceProject, monitor);
            IType[] jdtTypes = hierarchy.getAllSubtypes(baseType);
            if (jdtTypes == null || jdtTypes.length < 1) {
                return Collections.emptySet();
            }
            TreeSet<IType> collector = new TreeSet<IType>(new ElementNameComparator());
            for (IType candidate : jdtTypes) {
                if (filter != null && !filter.test(candidate)) continue;
                collector.add(candidate);
            }
            return collector;
        }
        catch (OperationCanceledException oce) {
            SdkLog.debug((CharSequence)"Strict hierarchy search has been canceled. An incomplete result will be returned.", (Object[])new Object[]{oce});
            return Collections.emptySet();
        }
        catch (JavaModelException e) {
            throw new SdkException((Throwable)e);
        }
    }

    public static Set<IType> resolveJdtTypes(CharSequence fqn) {
        return JdtUtils.resolveJdtTypes(fqn, SearchEngine.createWorkspaceScope());
    }

    public static Set<IType> resolveJdtTypes(final CharSequence fqn, IJavaSearchScope scope) {
        String fastPat = JavaTypes.simpleName((CharSequence)fqn);
        final TreeSet<IType> matchList = new TreeSet<IType>(COMPARATOR);
        try {
            new SearchEngine().search(SearchPattern.createPattern((String)fastPat, (int)0, (int)0, (int)0), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) {
                    IType t;
                    Object element = match.getElement();
                    if (element instanceof IType && (t = (IType)element).getFullyQualifiedName().contains(fqn)) {
                        matchList.add(t);
                    }
                }
            }, null);
        }
        catch (CoreException e) {
            throw new SdkException((Throwable)e);
        }
        return matchList;
    }

    public static IAnnotation getAnnotation(IAnnotatable element, String fullyQualifiedAnnotation) {
        String startFq;
        String startSimple;
        if (element == null) {
            return null;
        }
        String simpleName = JavaTypes.simpleName((CharSequence)fullyQualifiedAnnotation);
        IAnnotation result = JdtUtils.getAnnotation(element, simpleName, startSimple = "@" + simpleName, startFq = "@" + fullyQualifiedAnnotation);
        if (result != null) {
            return result;
        }
        return JdtUtils.getAnnotation(element, fullyQualifiedAnnotation, startSimple, startFq);
    }

    private static IAnnotation getAnnotation(IAnnotatable element, String name, String startSimple, String startFq) {
        IAnnotation annotation = element.getAnnotation(name);
        if (!JdtUtils.exists((IJavaElement)annotation)) {
            return null;
        }
        String annotSource = null;
        try {
            annotSource = annotation.getSource();
            if (annotSource != null) {
                annotSource = Strings.trim((CharSequence)annotSource).toString();
            }
        }
        catch (JavaModelException e) {
            SdkLog.warning((CharSequence)"Could not get source of annotation '{}' in element '{}'.", (Object[])new Object[]{name, element, e});
        }
        if (annotSource == null || annotSource.startsWith(startSimple) || annotSource.startsWith(startFq)) {
            return annotation;
        }
        if (element instanceof IMember && (annotSource = JdtUtils.getAnnotationSourceFixed((IMember)element, annotation, startSimple)) != null && (annotSource.startsWith(startSimple) || annotSource.startsWith(startFq))) {
            return annotation;
        }
        return null;
    }

    private static String getAnnotationSourceFixed(IMember member, IAnnotation annotation, String startSimple) {
        try {
            String diff;
            int offset;
            String icuSource;
            ISourceRange annotSourceRange = annotation.getSourceRange();
            ISourceRange ownerSourceRange = member.getSourceRange();
            if (SourceRange.isAvailable((ISourceRange)ownerSourceRange) && SourceRange.isAvailable((ISourceRange)annotSourceRange) && ownerSourceRange.getOffset() > annotSourceRange.getOffset() && (icuSource = member.getCompilationUnit().getSource()) != null && icuSource.length() >= ownerSourceRange.getOffset() && (offset = (diff = icuSource.substring(annotSourceRange.getOffset(), ownerSourceRange.getOffset())).lastIndexOf(startSimple)) >= 0) {
                int end = (offset += annotSourceRange.getOffset()) + annotSourceRange.getLength();
                if (icuSource.length() >= end) {
                    return icuSource.substring(offset, end);
                }
            }
        }
        catch (JavaModelException e) {
            SdkLog.warning((CharSequence)"Unable to find source for annotation '{}' in '{}'.", (Object[])new Object[]{annotation.getElementName(), member.getElementName(), e});
        }
        return null;
    }

    public static Set<IType> findAllTypesAnnotatedWith(String annotationName, IJavaSearchScope scope, final IProgressMonitor monitor) {
        final LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        SearchRequestor collector = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException("annotated types search canceled.");
                }
                Object object = match.getElement();
                if (object instanceof IType) {
                    IType t = (IType)object;
                    result.add(t);
                }
            }
        };
        for (IType annotationType : JdtUtils.resolveJdtTypes(annotationName, SearchEngine.createWorkspaceScope())) {
            if (monitor != null && monitor.isCanceled()) {
                return result;
            }
            SearchPattern pattern = SearchPattern.createPattern((IJavaElement)annotationType, (int)65536);
            try {
                new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, collector, monitor);
            }
            catch (OperationCanceledException oce) {
                SdkLog.debug((CharSequence)"Search for all types annotated with '{}' has been canceled.", (Object[])new Object[]{annotationName, oce});
            }
            catch (CoreException e) {
                throw new SdkException((Throwable)e);
            }
        }
        return result;
    }

    public static boolean exists(IJavaElement element) {
        return element != null && element.exists();
    }

    public static boolean isOnClasspath(IJavaElement element, IJavaProject project) {
        boolean isInWorkspace;
        if (!JdtUtils.exists(element) || !JdtUtils.exists((IJavaElement)project)) {
            return false;
        }
        boolean bl = isInWorkspace = element.getResource() != null;
        if (isInWorkspace) {
            IJavaProject javaProjectOfElement = element.getJavaProject();
            return project.equals(javaProjectOfElement) || project.isOnClasspath((IJavaElement)javaProjectOfElement);
        }
        return project.isOnClasspath(element);
    }

    public static BigDecimal getAnnotationValueNumeric(IAnnotation annotation, String name) {
        if (!JdtUtils.exists((IJavaElement)annotation)) {
            return null;
        }
        try {
            IMemberValuePair[] memberValues;
            for (IMemberValuePair p : memberValues = annotation.getMemberValuePairs()) {
                if (!Objects.equals(name, p.getMemberName())) continue;
                switch (p.getValueKind()) {
                    case 6: {
                        Double doubleValue = (Double)p.getValue();
                        return BigDecimal.valueOf(doubleValue);
                    }
                    case 5: {
                        Float floatValue = (Float)p.getValue();
                        return BigDecimal.valueOf(((Number)floatValue).doubleValue());
                    }
                    case 1: {
                        Integer intValue = (Integer)p.getValue();
                        return BigDecimal.valueOf(((Number)intValue).longValue());
                    }
                    case 2: {
                        Byte byteValue = (Byte)p.getValue();
                        return BigDecimal.valueOf(((Number)byteValue).longValue());
                    }
                    case 7: {
                        Long longValue = (Long)p.getValue();
                        return BigDecimal.valueOf(longValue);
                    }
                    case 3: {
                        Short shortValue = (Short)p.getValue();
                        return BigDecimal.valueOf(((Number)shortValue).longValue());
                    }
                }
                return null;
            }
            return null;
        }
        catch (JavaModelException e) {
            throw new SdkException((Throwable)e);
        }
    }

    public static String getAnnotationValueString(IAnnotation annotation, String name) {
        if (!JdtUtils.exists((IJavaElement)annotation)) {
            return null;
        }
        try {
            IMemberValuePair[] memberValues = annotation.getMemberValuePairs();
            return Arrays.stream(memberValues).filter(p -> Objects.equals(name, p.getMemberName())).map(IMemberValuePair::getValue).filter(Objects::nonNull).findFirst().map(Object::toString).orElse(null);
        }
        catch (JavaModelException e) {
            throw new SdkException((Throwable)e);
        }
    }

    public static IJavaSearchScope createJavaSearchScope(IJavaElement ... elements) {
        return SearchEngine.createJavaSearchScope((IJavaElement[])elements, (int)1);
    }

    public static IJavaSearchScope createJavaSearchScope(Collection<IResource> resources) {
        if (resources == null || resources.isEmpty()) {
            return null;
        }
        HashSet<IJavaElement> jset = new HashSet<IJavaElement>(resources.size());
        block12: for (IResource resource : resources) {
            if (resource == null || !resource.isAccessible()) continue;
            int type = resource.getType();
            switch (type) {
                case 4: {
                    IProject project = (IProject)resource;
                    try {
                        if (!project.isAccessible() || !project.hasNature("org.eclipse.jdt.core.javanature")) continue block12;
                        JdtUtils.addJavaElement(jset, (IJavaElement)JavaCore.create((IProject)project));
                        break;
                    }
                    catch (CoreException e) {
                        throw new SdkException((Throwable)e);
                    }
                }
                case 1: {
                    JdtUtils.addJavaElement(jset, JavaCore.create((IFile)((IFile)resource)));
                    break;
                }
                case 2: {
                    try {
                        resource.accept(proxy -> {
                            if (proxy.getType() == 2) {
                                IFolder folder = (IFolder)proxy.requestResource();
                                JdtUtils.addJavaElement(jset, JavaCore.create((IFolder)folder));
                                return true;
                            }
                            return false;
                        }, 0);
                        break;
                    }
                    catch (CoreException e) {
                        throw new SdkException((Throwable)e);
                    }
                }
                case 8: {
                    IJavaModel model = JavaCore.create((IWorkspaceRoot)((IWorkspaceRoot)resource));
                    if (!JdtUtils.exists((IJavaElement)model)) continue block12;
                    try {
                        for (IJavaProject jp : model.getJavaProjects()) {
                            JdtUtils.addJavaElement(jset, (IJavaElement)jp);
                        }
                        continue block12;
                    }
                    catch (JavaModelException e) {
                        throw new SdkException((Throwable)e);
                    }
                }
                default: {
                    throw new UnsupportedOperationException("Unknown resource type: " + type);
                }
            }
        }
        if (jset.isEmpty()) {
            return null;
        }
        return JdtUtils.createJavaSearchScope(jset.toArray(new IJavaElement[0]));
    }

    private static void addJavaElement(Collection<IJavaElement> collector, IJavaElement elementToAdd) {
        if (JdtUtils.exists(elementToAdd)) {
            collector.add(elementToAdd);
        }
    }

    public static boolean hierarchyContains(ITypeHierarchy h, String fqn) {
        return Arrays.stream(h.getAllTypes()).anyMatch(t -> fqn.equals(t.getFullyQualifiedName()));
    }

    public static IAnnotation getFirstAnnotationInSupertypeHierarchy(IType type, String ... fullyQualifiedAnnotations) {
        if (type == null) {
            return null;
        }
        IAnnotation ann = JdtUtils.getFirstDeclaredAnnotation((IAnnotatable)type, fullyQualifiedAnnotations);
        if (JdtUtils.exists((IJavaElement)ann)) {
            return ann;
        }
        try {
            ITypeHierarchy h = type.newSupertypeHierarchy(null);
            for (IType t : h.getAllSuperclasses(type)) {
                ann = JdtUtils.getFirstDeclaredAnnotation((IAnnotatable)t, fullyQualifiedAnnotations);
                if (!JdtUtils.exists((IJavaElement)ann)) continue;
                return ann;
            }
            for (IType t : h.getAllSuperInterfaces(type)) {
                ann = JdtUtils.getFirstDeclaredAnnotation((IAnnotatable)t, fullyQualifiedAnnotations);
                if (!JdtUtils.exists((IJavaElement)ann)) continue;
                return ann;
            }
            return null;
        }
        catch (JavaModelException e) {
            throw new SdkException((Throwable)e);
        }
    }

    private static IAnnotation getFirstDeclaredAnnotation(IAnnotatable element, String ... fullyQualifiedAnnotations) {
        return Arrays.stream(fullyQualifiedAnnotations).map(fqn -> JdtUtils.getAnnotation(element, fqn)).filter(JdtUtils::exists).findFirst().orElse(null);
    }

    public static class PublicAbstractPrimaryTypeFilter
    extends PublicPrimaryTypeFilter {
        @Override
        public boolean test(IType candidate) {
            boolean accept = super.test(candidate);
            if (!accept) {
                return false;
            }
            try {
                int modifiers = candidate.getFlags();
                return Flags.isAbstract((int)modifiers) && !Flags.isInterface((int)modifiers);
            }
            catch (JavaModelException e) {
                throw new SdkException((Throwable)e);
            }
        }
    }

    public static final class ElementNameComparator
    implements Comparator<IType>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(IType o1, IType o2) {
            if (o1 == o2) {
                return 0;
            }
            int res = o1.getElementName().compareTo(o2.getElementName());
            if (res != 0) {
                return res;
            }
            res = o1.getFullyQualifiedName().compareTo(o2.getFullyQualifiedName());
            if (res != 0) {
                return res;
            }
            return o1.toString().compareTo(o2.toString());
        }
    }

    private static final class P_TypeMatchComparator
    implements Comparator<IType>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private P_TypeMatchComparator() {
        }

        @Override
        public int compare(IType o1, IType o2) {
            boolean b2;
            if (o1 == o2) {
                return 0;
            }
            boolean b1 = o1.isBinary();
            if (b1 != (b2 = o2.isBinary())) {
                if (b1) {
                    return 1;
                }
                return -1;
            }
            String path1 = P_TypeMatchComparator.buildPath(o1);
            String path2 = P_TypeMatchComparator.buildPath(o2);
            return path2.compareTo(path1);
        }

        private static String buildPath(IType t) {
            String fqn = t.getFullyQualifiedName();
            String portableString = t.getPath().toPortableString();
            StringBuilder sb = new StringBuilder(fqn.length() + portableString.length());
            sb.append(fqn);
            sb.append(portableString);
            return sb.toString();
        }
    }

    public static class PublicPrimaryNonAbstractSourceTypeFilter
    extends PublicPrimaryTypeFilter {
        @Override
        public boolean test(IType candidate) {
            try {
                return super.test(candidate) && !Flags.isAbstract((int)candidate.getFlags()) && SourceRange.isAvailable((ISourceRange)candidate.getSourceRange());
            }
            catch (JavaModelException e) {
                SdkLog.warning((CharSequence)"Attempt to access source range of type '{}' failed. Type will be skipped.", (Object[])new Object[]{candidate.getFullyQualifiedName(), e});
                return false;
            }
        }
    }

    public static class PublicPrimaryTypeFilter
    implements Predicate<IType> {
        @Override
        public boolean test(IType candidate) {
            try {
                if (candidate.isMember() || candidate.isAnonymous() || candidate.isEnum() || candidate.isLocal()) {
                    return false;
                }
                int modifiers = candidate.getFlags();
                return Flags.isPublic((int)modifiers) && !Flags.isDeprecated((int)modifiers);
            }
            catch (JavaModelException e) {
                throw new SdkException((Throwable)e);
            }
        }
    }
}

