/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.wizards.pages;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class NewModelingProjectCreationWizardPage
extends WizardNewProjectCreationPage {
    public NewModelingProjectCreationWizardPage(String pageName) {
        super(pageName);
    }

    protected boolean validatePage() {
        this.setErrorMessage(null);
        this.setMessage(null);
        boolean validProjectName = true;
        if (this.resourceExistsInWorkspace()) {
            validProjectName = false;
        }
        if (!StringUtil.isEmpty((String)this.getProjectName()) && validProjectName && this.resourceExistsOnDisk()) {
            validProjectName = false;
        }
        return validProjectName;
    }

    private boolean resourceExistsOnDisk() {
        IFileStore store = ((Project)this.getProjectHandle()).getStore();
        String name = store.fetchInfo().getName();
        File folder = new File(this.getLocationPath().toOSString());
        if (folder.getName().equals(this.getProjectName())) {
            String msg = MessageFormat.format(Messages.localstore_fileExists, new Path(folder.toString()).removeLastSegments(1).append(folder.getName()).toOSString());
            this.setMessage(msg, 2);
        } else if (folder.getName().toUpperCase().equals(this.getProjectName().toUpperCase()) && NewModelingProjectCreationWizardPage.isMacOrWindowsOS()) {
            String msg = MessageFormat.format(Messages.resources_existsLocalDifferentCase, new Path(folder.toString()).removeLastSegments(1).append(folder.getName()).toOSString());
            this.setErrorMessage(msg);
            return true;
        }
        return this.resourceExistsInFolderLocation(store, name, folder);
    }

    private boolean resourceExistsInFolderLocation(IFileStore store, String name, File folder) {
        boolean projectNameExistsInSameCase = false;
        File[] files = folder.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length && !projectNameExistsInSameCase) {
                if (name != null && files[i].getName().equals(this.getProjectName())) {
                    msg = MessageFormat.format(Messages.localstore_fileExists, new Path(folder.toString()).append(files[i].getName()).toOSString());
                    this.setMessage(msg, 2);
                    projectNameExistsInSameCase = true;
                } else if (name != null && files[i].getName().toUpperCase().equals(this.getProjectName().toUpperCase()) && NewModelingProjectCreationWizardPage.isMacOrWindowsOS()) {
                    msg = MessageFormat.format(Messages.resources_existsLocalDifferentCase, new Path(folder.toString()).append(files[i].getName()).toOSString());
                    this.setErrorMessage(msg);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean resourceExistsInWorkspace() {
        boolean existsInWorkspace = false;
        if (!this.getProjectName().isEmpty()) {
            IProject[] projects = IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length && !existsInWorkspace) {
                if (this.getProjectName().toUpperCase().equals(projects[i].getName().toUpperCase()) && NewModelingProjectCreationWizardPage.isMacOrWindowsOS()) {
                    this.setErrorMessage(IDEWorkbenchMessages.WizardNewProjectCreationPage_projectExistsMessage);
                    existsInWorkspace = true;
                } else if (this.getProjectName().equals(projects[i].getName())) {
                    this.setErrorMessage(IDEWorkbenchMessages.WizardNewProjectCreationPage_projectExistsMessage);
                    return true;
                }
                ++i;
            }
        }
        return existsInWorkspace;
    }

    private static boolean isMacOrWindowsOS() {
        return System.getProperty("os.name").contains("Windows") || System.getProperty("os.name").contains("Mac");
    }
}

