/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.interpreter.internal.view.listener;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.ui.interpreter.internal.view.Variable;
import org.eclipse.sirius.ui.interpreter.internal.view.actions.ClearVariableViewerAction;
import org.eclipse.sirius.ui.interpreter.internal.view.actions.DeleteVariableOrValueAction;
import org.eclipse.sirius.ui.interpreter.internal.view.actions.NewVariableWizardAction;
import org.eclipse.sirius.ui.interpreter.internal.view.actions.RenameVariableAction;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class VariableMenuListener
implements IMenuListener {
    private TreeViewer variableViewer;

    public VariableMenuListener(TreeViewer variableViewer) {
        this.variableViewer = variableViewer;
    }

    public void menuAboutToShow(IMenuManager manager) {
        Variable variable = this.getCurrentVariable();
        manager.add((IAction)new NewVariableWizardAction(this.variableViewer, variable));
        manager.add((IAction)new ClearVariableViewerAction((Viewer)this.variableViewer));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new DeleteVariableOrValueAction(this.variableViewer));
        manager.add((IAction)new RenameVariableAction(this.variableViewer));
        manager.add((IContributionItem)new Separator("additions"));
    }

    private Variable getCurrentVariable() {
        if (this.variableViewer == null || this.variableViewer.getTree() == null || this.variableViewer.getTree().isDisposed()) {
            return null;
        }
        Tree tree = this.variableViewer.getTree();
        TreeItem[] selectedItems = tree.getSelection();
        Variable selectedVariable = null;
        if (selectedItems != null && selectedItems.length > 0) {
            TreeItem item;
            int i = 0;
            while (i < selectedItems.length && selectedVariable == null) {
                item = selectedItems[i];
                if (item.getData() instanceof Variable) {
                    selectedVariable = (Variable)item.getData();
                }
                ++i;
            }
            i = 0;
            while (i < selectedItems.length && selectedVariable == null) {
                item = selectedItems[i].getParentItem();
                while (item != null && selectedVariable == null) {
                    if (item.getData() instanceof Variable) {
                        selectedVariable = (Variable)item.getData();
                    }
                    item = item.getParentItem();
                }
                ++i;
            }
        }
        return selectedVariable;
    }
}

