/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.internal.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.sphinx.platform.internal.Activator;
import org.eclipse.sphinx.platform.resources.DefaultResourceChangeHandler;
import org.eclipse.sphinx.platform.resources.ResourceDeltaVisitor;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public class ContentTypeIdCachePurger
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        try {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(event.getType(), new DefaultResourceChangeHandler(){

                    @Override
                    public void handleFileChanged(int eventType, IFile file) {
                        ExtendedPlatform.removeCachedContentTypeId(file);
                    }

                    @Override
                    public void handleFileMoved(int eventType, IFile oldFile, IFile newFile) {
                        ExtendedPlatform.removeCachedContentTypeId(newFile);
                    }
                });
                delta.accept((IResourceDeltaVisitor)visitor);
            }
        }
        catch (CoreException ex) {
            PlatformLogUtil.logAsError(Activator.getDefault(), (Object)ex);
        }
    }
}

