/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.check.workflows;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.sphinx.emf.check.services.CheckProblemMarkerService;
import org.eclipse.sphinx.emf.mwe.dynamic.components.AbstractModelWorkflowComponent;
import org.eclipse.sphinx.emf.mwe.dynamic.components.IModelWorkflowComponent;

public abstract class AbstractCheckWorkflowComponent
extends AbstractModelWorkflowComponent
implements IModelWorkflowComponent {
    protected Set<String> categories = new HashSet<String>();

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        List models = (List)ctx.get("model");
        if (models != null && !models.isEmpty()) {
            for (EObject model : models) {
                try {
                    HashMap<String, Set<String>> contextEntries = new HashMap<String, Set<String>>();
                    contextEntries.put("CATEGORIES", this.categories);
                    Diagnostic diagnostic = Diagnostician.INSTANCE.validate(model, contextEntries);
                    CheckProblemMarkerService.INSTANCE.updateProblemMarkers(model, diagnostic);
                }
                catch (Exception ex) {
                    issues.addError((WorkflowComponent)this, ex.getMessage(), (Object)model, (Throwable)ex, null);
                }
            }
        }
    }
}

