/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.check;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.sphinx.emf.check.util.ExtendedEObjectValidator;

public class CompositeValidator
implements EValidator {
    private List<EValidator> children = new ArrayList<EValidator>();
    private ExtendedEObjectValidator extendedEObjectValidator = new ExtendedEObjectValidator();

    public CompositeValidator() {
    }

    public CompositeValidator(EValidator delegate) {
        this();
        this.addChild(delegate);
    }

    public void addChild(EValidator delegate) {
        if (this == delegate) {
            return;
        }
        if (!this.children.contains(delegate)) {
            this.children.add(delegate);
        }
    }

    public void removeChild(EValidator delegate) {
        if (this == delegate) {
            return;
        }
        if (this.children.contains(delegate)) {
            this.children.remove(delegate);
        }
    }

    public List<EValidator> getChildren() {
        return this.children;
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Object oldIntrinsicModelIntegrityConstraintsEnabled = null;
        if (this.needsToValidateIntrinsicConstraints(context)) {
            result &= this.extendedEObjectValidator.validate(eObject.eClass().getClassifierID(), eObject, diagnostics, context);
            oldIntrinsicModelIntegrityConstraintsEnabled = context.remove("ENABLE_INTRINSIC_MODEL_INTEGRITY_CONSTRAINTS");
        }
        for (EValidator validator : this.getChildren()) {
            result &= validator.validate(eObject, diagnostics, context);
        }
        if (oldIntrinsicModelIntegrityConstraintsEnabled != null) {
            context.put("ENABLE_INTRINSIC_MODEL_INTEGRITY_CONSTRAINTS", oldIntrinsicModelIntegrityConstraintsEnabled);
        }
        return result;
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Object oldIntrinsicModelIntegrityConstraintsEnabled = null;
        if (this.needsToValidateIntrinsicConstraints(context)) {
            result &= this.extendedEObjectValidator.validate(eClass.getClassifierID(), eObject, diagnostics, context);
            oldIntrinsicModelIntegrityConstraintsEnabled = context.remove("ENABLE_INTRINSIC_MODEL_INTEGRITY_CONSTRAINTS");
        }
        for (EValidator validator : this.getChildren()) {
            result &= validator.validate(eClass, eObject, diagnostics, context);
        }
        if (oldIntrinsicModelIntegrityConstraintsEnabled != null) {
            context.put("ENABLE_INTRINSIC_MODEL_INTEGRITY_CONSTRAINTS", oldIntrinsicModelIntegrityConstraintsEnabled);
        }
        return result;
    }

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Object oldIntrinsicModelIntegrityConstraintsEnabled = null;
        if (this.needsToValidateIntrinsicConstraints(context)) {
            result &= this.extendedEObjectValidator.validate(eDataType, value, diagnostics, context);
            oldIntrinsicModelIntegrityConstraintsEnabled = context.remove("ENABLE_INTRINSIC_MODEL_INTEGRITY_CONSTRAINTS");
        }
        for (EValidator validator : this.getChildren()) {
            result &= validator.validate(eDataType, value, diagnostics, context);
        }
        if (oldIntrinsicModelIntegrityConstraintsEnabled != null) {
            context.put("ENABLE_INTRINSIC_MODEL_INTEGRITY_CONSTRAINTS", oldIntrinsicModelIntegrityConstraintsEnabled);
        }
        return result;
    }

    protected boolean needsToValidateIntrinsicConstraints(Map<Object, Object> context) {
        return this.isIntrinsicModelIntegrityConstraintsEnabled(context) && !this.containsEObjectValidator();
    }

    protected boolean isIntrinsicModelIntegrityConstraintsEnabled(Map<Object, Object> context) {
        Assert.isNotNull(context);
        Object value = context.get("ENABLE_INTRINSIC_MODEL_INTEGRITY_CONSTRAINTS");
        return value != null && Boolean.parseBoolean(value.toString());
    }

    protected boolean containsEObjectValidator() {
        for (EValidator validator : this.getChildren()) {
            if (!(validator instanceof EObjectValidator)) continue;
            return true;
        }
        return false;
    }
}

