/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.loading.operations;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.scoping.ResourceScopeProviderRegistry;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.workspace.Activator;
import org.eclipse.sphinx.emf.workspace.internal.messages.Messages;
import org.eclipse.sphinx.emf.workspace.loading.SchedulingRuleFactory;
import org.eclipse.sphinx.platform.operations.AbstractWorkspaceOperation;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public class UpdateResourceURIOperation
extends AbstractWorkspaceOperation {
    private Map<IFile, IPath> filesToUpdate;

    public UpdateResourceURIOperation(Map<IFile, IPath> filesToUpdate) {
        super(Messages.job_updatingResourceURIs);
        this.filesToUpdate = filesToUpdate;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        this.runDetectAndUpdateResourceURIs(this.filesToUpdate, monitor);
    }

    public ISchedulingRule getRule() {
        return new SchedulingRuleFactory().createLoadSchedulingRule(this.filesToUpdate.keySet());
    }

    private void runDetectAndUpdateResourceURIs(Map<IFile, IPath> filesToUpdate, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(filesToUpdate);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.task_updatingResourceURIs, (int)100);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        Map<TransactionalEditingDomain, Map<IFile, IPath>> filesToUpdateResourceURIFor = this.detectFilesToUpdateResourceURIFor(filesToUpdate, (IProgressMonitor)progress.newChild(10));
        if (filesToUpdateResourceURIFor.size() == 0) {
            progress.done();
            return;
        }
        this.runUpdateResourceURIs(filesToUpdateResourceURIFor, (IProgressMonitor)progress.newChild(90));
    }

    private void runUpdateResourceURIs(Map<TransactionalEditingDomain, Map<IFile, IPath>> filesToUpdateResourceURIFor, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(filesToUpdateResourceURIFor);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)filesToUpdateResourceURIFor.keySet().size());
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        for (TransactionalEditingDomain editingDomain : filesToUpdateResourceURIFor.keySet()) {
            this.updateResourceURIsInEditingDomain(editingDomain, filesToUpdateResourceURIFor.get(editingDomain), (IProgressMonitor)progress.newChild(1));
        }
    }

    private void updateResourceURIsInEditingDomain(final TransactionalEditingDomain editingDomain, final Map<IFile, IPath> filesToUpdateResourceURIForInEditingDomain, final IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull((Object)editingDomain);
        Assert.isNotNull(filesToUpdateResourceURIForInEditingDomain);
        try {
            editingDomain.runExclusive(new Runnable(){

                @Override
                public void run() {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)filesToUpdateResourceURIForInEditingDomain.size());
                    if (progress.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    for (IFile oldFile : filesToUpdateResourceURIForInEditingDomain.keySet()) {
                        progress.subTask(NLS.bind((String)Messages.subtask_updatingResourceURI, (Object)oldFile.getFullPath().toString()));
                        URI oldURI = EcorePlatformUtil.createURI((IPath)oldFile.getFullPath());
                        Resource resource = editingDomain.getResourceSet().getResource(oldURI, false);
                        if (resource != null) {
                            IPath newPath = (IPath)filesToUpdateResourceURIForInEditingDomain.get(oldFile);
                            URI newURI = EcorePlatformUtil.createURI((IPath)newPath);
                            resource.setURI(newURI);
                        }
                        progress.worked(1);
                        progress.subTask("");
                        if (progress.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        editingDomain.yield();
                    }
                }
            });
        }
        catch (InterruptedException ex) {
            PlatformLogUtil.logAsWarning((Plugin)Activator.getDefault(), (Object)ex);
        }
    }

    private Map<TransactionalEditingDomain, Map<IFile, IPath>> detectFilesToUpdateResourceURIFor(Map<IFile, IPath> files, IProgressMonitor monitor) {
        Assert.isNotNull(files);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)files.size());
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        HashMap<TransactionalEditingDomain, Map<IFile, IPath>> filesToUpdateResourceURIFor = new HashMap<TransactionalEditingDomain, Map<IFile, IPath>>();
        for (IFile oldFile : files.keySet()) {
            try {
                if (!ResourceScopeProviderRegistry.INSTANCE.isNotInAnyScope(oldFile)) {
                    progress.subTask(NLS.bind((String)Messages.subtask_analyzingFile, (Object)oldFile.getFullPath()));
                    TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getCurrentEditingDomain((IFile)oldFile);
                    if (editingDomain != null) {
                        HashMap<IFile, IPath> filesToUpdateResourceURIForInEditingDomain = (HashMap<IFile, IPath>)filesToUpdateResourceURIFor.get(editingDomain);
                        if (filesToUpdateResourceURIForInEditingDomain == null) {
                            filesToUpdateResourceURIForInEditingDomain = new HashMap<IFile, IPath>();
                            filesToUpdateResourceURIFor.put(editingDomain, filesToUpdateResourceURIForInEditingDomain);
                        }
                        filesToUpdateResourceURIForInEditingDomain.put(oldFile, files.get(oldFile));
                    }
                }
            }
            catch (Exception ex) {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)ex);
            }
            progress.worked(1);
            progress.subTask("");
            if (!progress.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        return filesToUpdateResourceURIFor;
    }
}

