/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.internal.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sphinx.emf.Activator;
import org.eclipse.sphinx.emf.domain.factory.AbstractResourceSetListenerInstaller;
import org.eclipse.sphinx.emf.internal.messages.Messages;
import org.eclipse.sphinx.emf.internal.resource.ResourceProblemMarkerService;
import org.eclipse.sphinx.emf.saving.SaveIndicatorUtil;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.platform.IExtendedPlatformConstants;
import org.eclipse.sphinx.platform.resources.DefaultResourceChangeHandler;
import org.eclipse.sphinx.platform.resources.IResourceChangeHandler;
import org.eclipse.sphinx.platform.resources.MarkerJob;
import org.eclipse.sphinx.platform.resources.ResourceDeltaVisitor;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.sphinx.platform.util.StatusUtil;

public class ResourceProblemHandler
extends ResourceSetListenerImpl
implements IResourceChangeListener {
    public ResourceProblemHandler() {
        super(NotificationFilter.createFeatureFilter((EClassifier)EcorePackage.eINSTANCE.getEResource(), (int)4).or(NotificationFilter.createFeatureFilter((EClassifier)EcorePackage.eINSTANCE.getEResourceSet(), (int)0)));
    }

    public void setTarget(TransactionalEditingDomain domain) {
        super.setTarget(domain);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void unsetTarget(TransactionalEditingDomain domain) {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.unsetTarget(domain);
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        HashSet<Resource> loadedResources = new HashSet<Resource>();
        for (Notification notification : event.getNotifications()) {
            Object notifier = notification.getNotifier();
            if (notifier instanceof Resource) {
                Resource resource = (Resource)notifier;
                Boolean newValue = (Boolean)notification.getNewValue();
                if (!newValue.booleanValue()) continue;
                loadedResources.add(resource);
                continue;
            }
            if (!(notifier instanceof ResourceSet)) continue;
            Object newValue = notification.getNewValue();
            if (notification.getEventType() != 3 && notification.getEventType() != 5) continue;
            ArrayList<Resource> newResources = new ArrayList<Resource>();
            if (newValue instanceof List) {
                List newResourcesValue = (List)newValue;
                newResources.addAll(newResourcesValue);
            } else if (newValue instanceof Resource) {
                newResources.add((Resource)newValue);
            }
            loadedResources.addAll(newResources);
        }
        this.handleLoadedResources(loadedResources);
    }

    public boolean isPostcommitOnly() {
        return true;
    }

    protected void handleLoadedResources(final Collection<Resource> resources) {
        if (!resources.isEmpty()) {
            Job job = new Job(Messages.job_addingProblemMarkers){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ResourceProblemMarkerService.INSTANCE.addProblemMarkers(resources, monitor);
                        return Status.OK_STATUS;
                    }
                    catch (OperationCanceledException ex) {
                        return Status.CANCEL_STATUS;
                    }
                    catch (Exception ex) {
                        return StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
                    }
                }

                public boolean belongsTo(Object family) {
                    return IExtendedPlatformConstants.FAMILY_LONG_RUNNING.equals(family);
                }
            };
            job.setPriority(20);
            job.setRule(ExtendedPlatform.createModifySchedulingRule(this.getFiles(resources)));
            job.setSystem(true);
            job.schedule();
        }
    }

    private Collection<IFile> getFiles(Collection<Resource> resources) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        for (Resource resource : resources) {
            IFile file = EcorePlatformUtil.getFile(resource);
            files.add(file);
        }
        return files;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                final HashSet<IFile> changedFiles = new HashSet<IFile>();
                final HashSet<IFile> savedFiles = new HashSet<IFile>();
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(event.getType(), (IResourceChangeHandler)new DefaultResourceChangeHandler(){

                    public void handleFileChanged(int eventType, IFile file) {
                        changedFiles.add(file);
                        TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getMappedEditingDomain(file);
                        URI uri = EcorePlatformUtil.createURI(file.getFullPath());
                        if (SaveIndicatorUtil.isSaved((EditingDomain)editingDomain, uri)) {
                            savedFiles.add(file);
                        }
                    }
                });
                delta.accept((IResourceDeltaVisitor)visitor);
                this.handleChangedFiles(changedFiles);
                this.handleSavedFiles(savedFiles);
            }
        }
        catch (Exception ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getDefault(), (Object)ex);
        }
    }

    protected void handleChangedFiles(final Collection<IFile> files) {
        Assert.isNotNull(files);
        if (files.size() > 0) {
            Job job = new Job(Messages.job_removingProblemMarkers){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ResourceProblemMarkerService.INSTANCE.removeProblemMarkers(files, monitor);
                        MarkerJob.INSTANCE.schedule();
                        return Status.OK_STATUS;
                    }
                    catch (OperationCanceledException ex) {
                        return Status.CANCEL_STATUS;
                    }
                    catch (Exception ex) {
                        return StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
                    }
                }

                public boolean belongsTo(Object family) {
                    return IExtendedPlatformConstants.FAMILY_LONG_RUNNING.equals(family);
                }
            };
            job.setPriority(20);
            job.setRule(ExtendedPlatform.createModifySchedulingRule(files));
            job.setSystem(true);
            job.schedule();
        }
    }

    protected void handleSavedFiles(final Collection<IFile> files) {
        Assert.isNotNull(files);
        if (files.size() > 0) {
            Job job = new Job(Messages.job_addingProblemMarkers){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        HashSet<Resource> resources = new HashSet<Resource>();
                        for (IFile file : files) {
                            Resource resource = EcorePlatformUtil.getResource(file);
                            if (resource == null) continue;
                            resources.add(resource);
                        }
                        ResourceProblemMarkerService.INSTANCE.addProblemMarkers(resources, monitor);
                        return Status.OK_STATUS;
                    }
                    catch (OperationCanceledException ex) {
                        return Status.CANCEL_STATUS;
                    }
                    catch (Exception ex) {
                        return StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
                    }
                }

                public boolean belongsTo(Object family) {
                    return IExtendedPlatformConstants.FAMILY_LONG_RUNNING.equals(family);
                }
            };
            job.setPriority(20);
            job.setRule(ExtendedPlatform.createModifySchedulingRule(files));
            job.setSystem(true);
            job.schedule();
        }
    }

    public static class ResourceProblemHandlerInstaller
    extends AbstractResourceSetListenerInstaller<ResourceProblemHandler> {
        public ResourceProblemHandlerInstaller() {
            super(ResourceProblemHandler.class);
        }
    }
}

