/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.ui.views;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.sphinx.emf.validation.ui.views.ConcreteMarker;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerFilter;
import org.eclipse.sphinx.emf.validation.ui.views.ProblemMarker;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public class ProblemFilter
extends MarkerFilter {
    private static final String TAG_CONTAINS = "contains";
    private static final String TAG_DESCRIPTION = "description";
    private static final String TAG_SELECT_BY_SEVERITY = "selectBySeverity";
    private static final String TAG_SEVERITY = "severity";
    static final boolean DEFAULT_CONTAINS = true;
    static final String DEFAULT_DESCRIPTION = "";
    static final boolean DEFAULT_SELECT_BY_SEVERITY = false;
    static final int DEFAULT_SEVERITY = 0;
    public static final int SEVERITY_ERROR = 4;
    public static final int SEVERITY_WARNING = 2;
    public static final int SEVERITY_INFO = 1;
    private boolean contains;
    private String description;
    private boolean selectBySeverity;
    private int severity;
    private IPluginContribution contributionDescriptor = null;
    private IIdentifier identifier;

    public ProblemFilter(String filterName) {
        super(filterName, new String[]{"sphinx.emf.validation.problem.marker", "org.eclipse.sphinx.emf.xmlwellformednessproblemmarker", "org.eclipse.sphinx.emf.xmlintegrityproblemmarker", "org.eclipse.sphinx.emf.xmlvalidityproblemmarker"});
        IWorkbenchPage page;
        IWorkbenchWindow window;
        if (PlatformUI.getPreferenceStore().getBoolean("USE_WINDOW_WORKING_SET_BY_DEFAULT") && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
            this.setOnResource(4);
            this.setWorkingSet(page.getAggregateWorkingSet());
        }
    }

    @Override
    public boolean selectMarker(ConcreteMarker marker) {
        if (!(marker instanceof ProblemMarker)) {
            return false;
        }
        ProblemMarker problemMarker = (ProblemMarker)marker;
        return !this.isEnabled() || super.selectMarker(problemMarker) && this.selectByDescription(problemMarker) && this.selectBySeverity(problemMarker);
    }

    private boolean selectByDescription(ConcreteMarker item) {
        if (this.description == null || this.description.equals(DEFAULT_DESCRIPTION)) {
            return true;
        }
        String markerDescription = item.getDescription();
        int index = markerDescription.indexOf(this.description);
        return this.contains ? index >= 0 : index < 0;
    }

    private boolean selectBySeverity(ProblemMarker item) {
        if (this.selectBySeverity) {
            int markerSeverity = item.getSeverity();
            if (markerSeverity == 2) {
                return (this.severity & 4) > 0;
            }
            if (markerSeverity == 1) {
                return (this.severity & 2) > 0;
            }
            if (markerSeverity == 0) {
                return (this.severity & 1) > 0;
            }
        }
        return true;
    }

    public boolean getContains() {
        return this.contains;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getSelectBySeverity() {
        return this.selectBySeverity;
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setContains(boolean contains) {
        this.contains = contains;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSelectBySeverity(boolean selectBySeverity) {
        this.selectBySeverity = selectBySeverity;
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    @Override
    public void resetState() {
        super.resetState();
        this.contains = true;
        this.description = DEFAULT_DESCRIPTION;
        this.selectBySeverity = false;
        this.severity = 0;
    }

    @Override
    public void restoreFilterSettings(IDialogSettings settings) {
        super.restoreFilterSettings(settings);
        String setting = settings.get(TAG_CONTAINS);
        if (setting != null) {
            this.contains = Boolean.valueOf(setting);
        }
        if ((setting = settings.get(TAG_DESCRIPTION)) != null) {
            this.description = new String(setting);
        }
        if ((setting = settings.get(TAG_SELECT_BY_SEVERITY)) != null) {
            this.selectBySeverity = Boolean.valueOf(setting);
        }
        if ((setting = settings.get(TAG_SEVERITY)) != null) {
            try {
                this.severity = Integer.parseInt(setting);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void restoreFilterSettings(IMemento memento) {
        super.restoreFilterSettings(memento);
        String setting = memento.getString(TAG_CONTAINS);
        if (setting != null) {
            this.contains = Boolean.valueOf(setting);
        }
        if ((setting = memento.getString(TAG_DESCRIPTION)) != null) {
            this.description = new String(setting);
        }
        if ((setting = memento.getString(TAG_SELECT_BY_SEVERITY)) != null) {
            this.selectBySeverity = Boolean.valueOf(setting);
        }
        Integer severitySetting = memento.getInteger(TAG_SEVERITY);
        if (setting != null) {
            this.severity = severitySetting;
        }
    }

    @Override
    public void saveFilterSettings(IMemento settings) {
        super.saveFilterSettings(settings);
        settings.putString(TAG_CONTAINS, String.valueOf(this.contains));
        settings.putString(TAG_DESCRIPTION, this.description);
        settings.putString(TAG_SELECT_BY_SEVERITY, String.valueOf(this.selectBySeverity));
        settings.putInteger(TAG_SEVERITY, this.severity);
    }

    public String getId() {
        if (this.contributionDescriptor == null) {
            return null;
        }
        return this.contributionDescriptor.getLocalId();
    }

    void createContributionFrom(IConfigurationElement element) {
        final String id = element.getAttribute("id");
        final String namespace = element.getNamespace();
        this.contributionDescriptor = new IPluginContribution(){

            public String getLocalId() {
                return id;
            }

            public String getPluginId() {
                return namespace;
            }
        };
    }

    public boolean isFilteredOutByActivity() {
        if (this.contributionDescriptor == null) {
            return false;
        }
        if (this.identifier == null) {
            this.identifier = WorkbenchActivityHelper.getIdentifier((IPluginContribution)this.contributionDescriptor);
        }
        return !this.identifier.isEnabled();
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && !this.isFilteredOutByActivity();
    }
}

