/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.testutils.integration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.workspace.domain.mapping.AbstractWorkspaceEditingDomainMapping;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.sphinx.testutils.integration.ReferenceWorkspaceChangeListener;
import org.eclipse.sphinx.testutils.integration.ResourceProblemListener;
import org.eclipse.sphinx.testutils.integration.internal.IInternalReferenceWorkspace;
import org.eclipse.sphinx.testutils.integration.internal.ReferenceEditingDomainDescriptor;
import org.eclipse.sphinx.testutils.integration.internal.ReferenceModelDescriptor;
import org.eclipse.sphinx.testutils.integration.internal.ReferenceProjectDescriptor;

public abstract class AbstractReferenceWorkspace
implements IInternalReferenceWorkspace {
    private Map<IMetaModelDescriptor, ReferenceEditingDomainDescriptor> referenceEditingDomainsDescriptors = new HashMap<IMetaModelDescriptor, ReferenceEditingDomainDescriptor>();
    private Set<ReferenceProjectDescriptor> referenceProjectDescriptors = new HashSet<ReferenceProjectDescriptor>();

    public AbstractReferenceWorkspace(Set<String> referenceProjectSubset) {
        this.initContentDescriptors(referenceProjectSubset);
        this.initContentAccessors();
    }

    protected final void initContentDescriptors(Set<String> referenceProjectSubset) {
        this.initReferenceProjectDescriptors(referenceProjectSubset);
        this.initReferenceFileDescriptors();
    }

    protected void initContentAccessors() {
    }

    private void initReferenceProjectDescriptors(Set<String> referenceProjectSubset) {
        Assert.isNotNull(referenceProjectSubset);
        if (referenceProjectSubset.isEmpty()) {
            referenceProjectSubset.addAll(Arrays.asList(this.getReferenceProjectsNames()));
        }
        for (String referenceProjectName : referenceProjectSubset) {
            this.addReferenceProjectDescriptor(referenceProjectName);
        }
    }

    private void addReferenceProjectDescriptor(String projectName) {
        if (this.referenceProjectDescriptors == null) {
            this.referenceProjectDescriptors = new HashSet<ReferenceProjectDescriptor>();
        }
        for (ReferenceProjectDescriptor projectDescriptor : this.referenceProjectDescriptors) {
            if (!projectDescriptor.getProjectName().equals(projectName)) continue;
            return;
        }
        this.referenceProjectDescriptors.add(new ReferenceProjectDescriptor(projectName));
    }

    protected abstract void initReferenceFileDescriptors();

    protected void addFileDescriptors(String projectName, String[] filesPath) {
        if (projectName != null && filesPath != null) {
            String[] stringArray = filesPath;
            int n = filesPath.length;
            int n2 = 0;
            while (n2 < n) {
                String relativeFilePath = stringArray[n2];
                this.addFileDescriptor(projectName, relativeFilePath);
                ++n2;
            }
        }
    }

    protected void addFileDescriptor(String projectName, String relativeFilePath) {
        ReferenceProjectDescriptor projectDescriptor;
        if (projectName != null && relativeFilePath != null && (projectDescriptor = this.getReferenceProjectDescriptor(projectName)) != null) {
            projectDescriptor.addFile(relativeFilePath, null);
        }
    }

    protected void addFileDescriptors(String projectName, String[] filesPath, IMetaModelDescriptor metaModeldescriptor) {
        if (projectName != null && filesPath != null) {
            String[] stringArray = filesPath;
            int n = filesPath.length;
            int n2 = 0;
            while (n2 < n) {
                String relativeFilePath = stringArray[n2];
                this.addFileDescriptor(projectName, relativeFilePath, metaModeldescriptor);
                ++n2;
            }
        }
    }

    protected void addFileDescriptor(String projectName, String relativeFilePath, IMetaModelDescriptor metaModelDescriptor) {
        ReferenceProjectDescriptor referenceProjectDescriptor;
        ReferenceEditingDomainDescriptor referenceEditingDomainDescriptor = this.getReferenceEditingDomainDescriptor(metaModelDescriptor);
        if (referenceEditingDomainDescriptor == null) {
            String editingDomainId = AbstractWorkspaceEditingDomainMapping.getDefaultEditingDomainId(Collections.singleton(metaModelDescriptor));
            this.addEditingDomainDescriptor(metaModelDescriptor, editingDomainId);
            referenceEditingDomainDescriptor = this.getReferenceEditingDomainDescriptor(metaModelDescriptor);
        }
        if ((referenceProjectDescriptor = this.getReferenceProjectDescriptor(projectName)) != null) {
            referenceProjectDescriptor.addFile(relativeFilePath, metaModelDescriptor);
            IPath referenceProjectPath = referenceProjectDescriptor.getProject().getFullPath();
            referenceEditingDomainDescriptor.addResourceURI(URI.createPlatformResourceURI((String)referenceProjectPath.append(relativeFilePath).toString(), (boolean)true));
            this.addReferenceModelDescriptor(metaModelDescriptor, referenceEditingDomainDescriptor, referenceProjectDescriptor);
        }
    }

    private void addEditingDomainDescriptor(IMetaModelDescriptor metaModelDescriptor, String editingDomainName) {
        ReferenceEditingDomainDescriptor referenceEditingDomainsDescriptor;
        if (this.referenceEditingDomainsDescriptors != null && this.getReferenceEditingDomainDescriptor(metaModelDescriptor) == null && (referenceEditingDomainsDescriptor = this.referenceEditingDomainsDescriptors.get(metaModelDescriptor)) == null) {
            this.referenceEditingDomainsDescriptors.put(metaModelDescriptor, new ReferenceEditingDomainDescriptor(editingDomainName));
        }
    }

    private void addReferenceModelDescriptor(IMetaModelDescriptor metaModelDescriptor, ReferenceEditingDomainDescriptor referenceEditingDomainDescriptor, ReferenceProjectDescriptor referenceProjectDescriptor) {
        Assert.isNotNull((Object)metaModelDescriptor);
        Assert.isNotNull((Object)referenceEditingDomainDescriptor);
        Assert.isNotNull((Object)referenceProjectDescriptor);
        ReferenceModelDescriptor referenceModelDescriptor = new ReferenceModelDescriptor(metaModelDescriptor, referenceEditingDomainDescriptor.name, referenceProjectDescriptor.getProject());
        referenceProjectDescriptor.addReferenceModelDescriptor(referenceModelDescriptor);
        for (IProject referencingProject : ExtendedPlatform.getAllReferencingProjects((IProject)referenceProjectDescriptor.getProject())) {
            ReferenceProjectDescriptor referencingReferenceProjectDescriptor = this.getReferenceProjectDescriptor(referencingProject.getName());
            if (referencingReferenceProjectDescriptor == null) continue;
            ReferenceModelDescriptor forwardedReferenceModelDescriptor = new ReferenceModelDescriptor(metaModelDescriptor, referenceEditingDomainDescriptor.name, referencingProject);
            referencingReferenceProjectDescriptor.addReferenceModelDescriptor(forwardedReferenceModelDescriptor);
        }
    }

    @Override
    public void addResourceSetProblemListener(ResourceProblemListener resourceProblemListener) {
        for (IMetaModelDescriptor metaModelDescriptor : this.referenceEditingDomainsDescriptors.keySet()) {
            TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((IContainer)ResourcesPlugin.getWorkspace().getRoot(), (IMetaModelDescriptor)metaModelDescriptor);
            if (editingDomain == null) continue;
            editingDomain.addResourceSetListener((ResourceSetListener)resourceProblemListener);
        }
    }

    @Override
    public void removeResourceSetProblemListener(ResourceProblemListener resourceProblemListener) {
        for (IMetaModelDescriptor metaModelDescriptor : this.referenceEditingDomainsDescriptors.keySet()) {
            TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((IContainer)ResourcesPlugin.getWorkspace().getRoot(), (IMetaModelDescriptor)metaModelDescriptor);
            if (editingDomain == null) continue;
            editingDomain.removeResourceSetListener((ResourceSetListener)resourceProblemListener);
        }
    }

    @Override
    public void addReferenceWorkspaceChangeListener(ReferenceWorkspaceChangeListener referenceWorkspaceChangeListener) {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)referenceWorkspaceChangeListener);
    }

    @Override
    public void removeReferenceWorkspaceChangeListener(ReferenceWorkspaceChangeListener referenceWorkspaceChangeListener) {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)referenceWorkspaceChangeListener);
    }

    @Override
    public ReferenceEditingDomainDescriptor getReferenceEditingDomainDescriptor(IMetaModelDescriptor metaModeldescriptor) {
        if (this.referenceEditingDomainsDescriptors != null && metaModeldescriptor != null) {
            return this.referenceEditingDomainsDescriptors.get(metaModeldescriptor);
        }
        return null;
    }

    @Override
    public Map<IMetaModelDescriptor, ReferenceEditingDomainDescriptor> getReferenceEditingDomainDescritpors() {
        return this.referenceEditingDomainsDescriptors;
    }

    @Override
    public int getInitialReferenceEditingDomainCount() {
        if (this.referenceEditingDomainsDescriptors != null) {
            return this.referenceEditingDomainsDescriptors.size();
        }
        return 0;
    }

    @Override
    public int getInitialResourcesInReferenceEditingDomainCount(IMetaModelDescriptor metaModeldescriptor) {
        ReferenceEditingDomainDescriptor referenceEditingDomainDescriptor = this.getReferenceEditingDomainDescriptor(metaModeldescriptor);
        if (referenceEditingDomainDescriptor != null) {
            return referenceEditingDomainDescriptor.getResourceURIs().size();
        }
        return 0;
    }

    @Override
    public int getInitialResourcesInAllReferenceEditingDomainCount() {
        int count = 0;
        if (this.referenceEditingDomainsDescriptors != null) {
            for (IMetaModelDescriptor metaModelDescriptor : this.referenceEditingDomainsDescriptors.keySet()) {
                count += this.getInitialResourcesInReferenceEditingDomainCount(metaModelDescriptor);
            }
        }
        return count;
    }

    @Override
    public Set<IFile> getAllReferenceFiles() {
        Assert.isNotNull(this.referenceProjectDescriptors);
        HashSet<IFile> results = new HashSet<IFile>();
        for (ReferenceProjectDescriptor referenceProjectDescriptor : this.referenceProjectDescriptors) {
            if (referenceProjectDescriptor == null) continue;
            results.addAll(referenceProjectDescriptor.getAllFiles());
        }
        return results;
    }

    @Override
    public Set<IFile> getReferenceFiles(IMetaModelDescriptor metaModelDescriptor) {
        Assert.isNotNull(this.referenceProjectDescriptors);
        HashSet<IFile> results = new HashSet<IFile>();
        for (ReferenceProjectDescriptor referenceProjectDescriptor : this.referenceProjectDescriptors) {
            if (referenceProjectDescriptor == null) continue;
            results.addAll(referenceProjectDescriptor.getFiles(metaModelDescriptor));
        }
        return results;
    }

    @Override
    public Set<String> getReferenceFileNames(IMetaModelDescriptor metaModelDescriptor) {
        Assert.isNotNull(this.referenceProjectDescriptors);
        HashSet<String> results = new HashSet<String>();
        for (ReferenceProjectDescriptor referenceProjectDescriptor : this.referenceProjectDescriptors) {
            if (referenceProjectDescriptor == null) continue;
            for (IFile file : referenceProjectDescriptor.getFiles(metaModelDescriptor)) {
                results.add(file.getName());
            }
        }
        return results;
    }

    @Override
    public Set<IFile> getReferenceFiles(String projectName) {
        ReferenceProjectDescriptor referenceProjectdescriptor = this.getReferenceProjectDescriptor(projectName);
        if (referenceProjectdescriptor != null) {
            return referenceProjectdescriptor.getAllFiles();
        }
        return new HashSet<IFile>();
    }

    @Override
    public Set<IFile> getReferenceFiles(String projectName, IMetaModelDescriptor metaModelDescriptor) {
        ReferenceProjectDescriptor referenceProjectdescriptor = this.getReferenceProjectDescriptor(projectName);
        if (referenceProjectdescriptor != null) {
            return referenceProjectdescriptor.getFiles(metaModelDescriptor);
        }
        return new HashSet<IFile>();
    }

    @Override
    public IFile getReferenceFile(String projectName, String fileName) {
        ReferenceProjectDescriptor referenceProjectDescriptor = this.getReferenceProjectDescriptor(projectName);
        if (referenceProjectDescriptor != null) {
            return referenceProjectDescriptor.getFile(fileName);
        }
        return null;
    }

    public IFile getReferenceFile(IPath filePath) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
    }

    protected abstract String[] getReferenceProjectsNames();

    @Override
    public IProject getReferenceProject(String projectName) {
        ReferenceProjectDescriptor referenceProjectdescriptor = this.getReferenceProjectDescriptor(projectName);
        if (referenceProjectdescriptor != null) {
            return referenceProjectdescriptor.getProject();
        }
        return null;
    }

    @Override
    public List<String> getReferenceFileNames(String projectName, IMetaModelDescriptor metaModelDescriptor) {
        ReferenceProjectDescriptor referenceProjectDescriptor = this.getReferenceProjectDescriptor(projectName);
        if (referenceProjectDescriptor != null) {
            return referenceProjectDescriptor.getFileNames(metaModelDescriptor);
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> getReferenceFileNames(String projectName) {
        ReferenceProjectDescriptor referenceProjectDescriptor = this.getReferenceProjectDescriptor(projectName);
        if (referenceProjectDescriptor != null) {
            return referenceProjectDescriptor.getAllFileNames();
        }
        return new ArrayList<String>();
    }

    @Override
    public ReferenceProjectDescriptor getReferenceProjectDescriptor(String projectName) {
        Assert.isNotNull(this.referenceProjectDescriptors);
        for (ReferenceProjectDescriptor projectDescriptor : this.referenceProjectDescriptors) {
            if (!projectDescriptor.getProjectName().equals(projectName)) continue;
            return projectDescriptor;
        }
        return null;
    }

    public Map<String, IProject> getReferenceProjectAccessors() {
        Assert.isNotNull(this.referenceProjectDescriptors);
        HashMap<String, IProject> projects = new HashMap<String, IProject>();
        for (ReferenceProjectDescriptor projcetDescriptor : this.referenceProjectDescriptors) {
            projects.put(projcetDescriptor.getProjectName(), projcetDescriptor.getProject());
        }
        return projects;
    }

    @Override
    public Set<ReferenceProjectDescriptor> getReferenceProjectDescriptors() {
        return this.referenceProjectDescriptors;
    }

    protected final IProject createSimpleProject(final String projectName) throws CoreException {
        final IProject[] project = new IProject[1];
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project[0] = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (!project[0].exists()) {
                    project[0].create(null);
                    project[0].open(null);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, null);
        return project[0];
    }
}

