/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.base.ui.processing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingConfig;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingOperation;
import org.eclipse.statet.docmlet.base.ui.processing.operations.CheckOutputOperation;
import org.eclipse.statet.docmlet.base.ui.processing.operations.OpenUsingEclipseOperation;
import org.eclipse.statet.ecommons.io.FileValidator;
import org.eclipse.statet.ecommons.resources.core.variables.ResourceVariableResolver;
import org.eclipse.statet.ecommons.resources.core.variables.ResourceVariables;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.workspace.ResourceVariableUtil;
import org.eclipse.statet.ecommons.variables.core.DynamicVariable;
import org.eclipse.statet.ecommons.variables.core.StaticVariable;
import org.eclipse.statet.ecommons.variables.core.VariableText2;
import org.eclipse.statet.ecommons.variables.core.VariableUtils;
import org.eclipse.statet.internal.docmlet.base.ui.processing.Messages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.ui.IWorkbenchPage;

@NonNullByDefault
public abstract class DocProcessingToolConfig {
    private ImList<StepConfig> steps;
    private @Nullable Map<String, IStringVariable> globalVariables;
    private IFile sourceFile;
    private ResourceVariableUtil sourceFileUtil;
    private IContainer workingDirectory;

    protected static CoreException createMissingConfigAttr(String attrName) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", NLS.bind((String)"Invalid configuration: configuration attribute ''{0}'' is missing.", (Object)attrName)));
    }

    protected static CoreException createValidationFailed(FileValidator validator) {
        IStatus status = validator.getStatus();
        return new CoreException((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", status.getMessage()));
    }

    protected void setSteps(StepConfig ... steps) {
        this.steps = ImCollections.newList((Object[])steps);
    }

    public ImList<StepConfig> getSteps() {
        return this.steps;
    }

    public @Nullable StepConfig getStep(String stepId) {
        for (StepConfig aStep : this.steps) {
            if (aStep.getId() != stepId) continue;
            return aStep;
        }
        return null;
    }

    public Map<String, IStringVariable> getVariables() {
        Map<String, IStringVariable> globalVariables = this.globalVariables;
        if (globalVariables == null) {
            this.globalVariables = globalVariables = new HashMap<String, IStringVariable>();
        }
        return globalVariables;
    }

    public void initSourceFile(ILaunchConfiguration configuration, SubMonitor m) throws CoreException {
        FileValidator validator = new FileValidator(true);
        validator.setResourceLabel("source document");
        validator.setRequireWorkspace(true, true);
        validator.setOnDirectory(4);
        IPath explicitePath = null;
        String path = configuration.getAttribute("org.eclipse.statet.docmlet.base/run/DocSource.path", null);
        if (path != null) {
            explicitePath = Path.fromPortableString((String)path);
        }
        if (explicitePath != null) {
            validator.setExplicit((Object)explicitePath);
        } else {
            UIAccess.getDisplay().syncExec(() -> {
                ResourceVariableUtil util = new ResourceVariableUtil();
                util.getResource();
                this.sourceFileUtil = util;
            });
            if (this.sourceFileUtil.getResource() == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", "No resource for 'source document' selected in the active Workbench window."));
            }
            validator.setExplicit((Object)this.sourceFileUtil.getResource());
        }
        if (validator.getStatus().getSeverity() == 4) {
            throw DocProcessingToolConfig.createValidationFailed(validator);
        }
        this.setSourceFile((IFile)ObjectUtils.nonNullAssert((Object)((IFile)validator.getWorkspaceResource())));
    }

    protected void setSourceFile(IFile file) {
        this.sourceFile = file;
        ResourceVariableUtil sourceFileUtil = (ResourceVariableUtil)ObjectUtils.nullable((Object)this.sourceFileUtil);
        if (sourceFileUtil == null) {
            sourceFileUtil = (ResourceVariableUtil)UIAccess.syncExecGet(() -> new ResourceVariableUtil((IResource)file));
            this.sourceFileUtil = (ResourceVariableUtil)ObjectUtils.nonNullAssert((Object)sourceFileUtil);
        }
        Map<String, IStringVariable> variables = this.getVariables();
        VariableUtils.add(variables, (Collection)ResourceVariables.getSingleResourceVariables(), (IDynamicVariableResolver)new ResourceVariableResolver((ResourceVariableResolver.Context)this.sourceFileUtil));
        VariableUtils.add(variables, (IStringVariable)new StaticVariable((IStringVariable)DocProcessingConfig.SOURCE_FILE_PATH_VAR, file.getFullPath().toString()));
    }

    public IWorkbenchPage getWorkbenchPage() {
        return this.sourceFileUtil.getWorkbenchPage();
    }

    public IFile getSourceFile() {
        return this.sourceFile;
    }

    public ResourceVariableUtil getSourceFileVariableUtil() {
        return this.sourceFileUtil;
    }

    public void initWorkingDirectory(ILaunchConfiguration configuration, SubMonitor m) throws CoreException {
        String wdAttrName = "org.eclipse.statet.docmlet.base/main/WorkingDirectory.path";
        FileValidator validator = new FileValidator(true);
        validator.setResourceLabel("working directory");
        validator.setRequireWorkspace(true, true);
        validator.setOnFile(4);
        validator.setVariableResolver(new VariableText2(this.getVariables()));
        String path = configuration.getAttribute("org.eclipse.statet.docmlet.base/main/WorkingDirectory.path", null);
        if (path == null || path.isEmpty()) {
            throw DocProcessingToolConfig.createMissingConfigAttr("org.eclipse.statet.docmlet.base/main/WorkingDirectory.path");
        }
        validator.setExplicit((Object)path);
        if (validator.getStatus().getSeverity() == 4) {
            throw DocProcessingToolConfig.createValidationFailed(validator);
        }
        this.setWorkingDirectory((IContainer)ObjectUtils.nonNullAssert((Object)((IContainer)validator.getWorkspaceResource())));
    }

    protected void setWorkingDirectory(IContainer directory) {
        this.workingDirectory = directory;
        ResourceVariableResolver resolver = new ResourceVariableResolver(){

            public String resolveValue(IDynamicVariable variable, @Nullable String argument) throws CoreException {
                switch (variable.getName()) {
                    case "wd_loc": {
                        return this.toLocValue(variable, (IResource)DocProcessingToolConfig.this.getWorkingDirectory());
                    }
                    case "wd_path": {
                        return this.toPathValue(variable, (IResource)DocProcessingToolConfig.this.getWorkingDirectory());
                    }
                }
                throw new UnsupportedOperationException(variable.getName());
            }
        };
        Map<String, IStringVariable> variables = this.getVariables();
        VariableUtils.add(variables, (IStringVariable)new DynamicVariable.ResolverVariable("wd_loc", null, false, (IDynamicVariableResolver)resolver));
        VariableUtils.add(variables, (IStringVariable)new DynamicVariable.ResolverVariable("wd_path", null, false, (IDynamicVariableResolver)resolver));
    }

    public IContainer getWorkingDirectory() {
        return this.workingDirectory;
    }

    protected String getOutputExt(StepConfig stepConfig, String formatKey, SubMonitor m) throws CoreException {
        if (formatKey.startsWith("ext:")) {
            return formatKey.substring("ext:".length());
        }
        throw new UnsupportedOperationException("formatKey= " + formatKey);
    }

    protected @Nullable String resolveExt(StepConfig stepConfig, DocProcessingConfig.Format format) {
        return format.getExt(stepConfig.getInputFile().getFileExtension());
    }

    protected abstract @Nullable DocProcessingOperation createStepOperation(String var1);

    public static class PreviewStepConfig
    extends StepConfig {
        public PreviewStepConfig(DocProcessingToolConfig config) {
            super(config, "org.eclipse.statet.docmlet.base/preview", Messages.Preview_label);
        }

        @Override
        protected boolean resolveOutputFile() {
            return false;
        }
    }

    public static class ProcessingStepConfig
    extends StepConfig {
        public ProcessingStepConfig(DocProcessingToolConfig config, String id, String label) {
            super(config, id, label);
        }

        @Override
        public void initPost(ILaunchConfiguration configuration, SubMonitor m) throws CoreException {
            DocProcessingOperation operation;
            m.setWorkRemaining(2);
            if (this.isOptionEnabled(configuration.getAttribute(String.valueOf(this.getId()) + '/' + "Post.OpenOutput.enabled", "always"))) {
                operation = new CheckOutputOperation();
                ((CheckOutputOperation)operation).init(this, DocProcessingOperation.NO_SETTINGS, m.newChild(1, 6));
                this.addPost(operation);
            }
            m.setWorkRemaining(1);
            if (this.isOptionEnabled(configuration.getAttribute(String.valueOf(this.getId()) + '/' + "Post.OpenOutput.enabled", "disabled"))) {
                operation = new OpenUsingEclipseOperation(this.getOutputFile());
                ((OpenUsingEclipseOperation)operation).init(this, DocProcessingOperation.NO_SETTINGS, m.newChild(1, 6));
                ((OpenUsingEclipseOperation)operation).setFailSeverity(this.getRun() == 2 ? 4 : 2);
                this.addPost(operation);
            }
            m.done();
        }
    }

    public static class StepConfig {
        public static final byte RUN_NO = 0;
        public static final byte RUN_DEFAULT = 1;
        public static final byte RUN_EXPLICITE = 2;
        private final DocProcessingToolConfig config;
        private final String id;
        private final String label;
        private byte run;
        private boolean isEnabled;
        private IFile inputFile;
        private ResourceVariableUtil inputFileUtil;
        private IFile outputFile;
        private @Nullable DocProcessingOperation operation;
        private final List<DocProcessingOperation> preOperations = new ArrayList<DocProcessingOperation>();
        private final List<DocProcessingOperation> postOperations = new ArrayList<DocProcessingOperation>();
        private @Nullable VariableText2 variableText;

        public StepConfig(DocProcessingToolConfig config, String id, String label) {
            this.config = config;
            this.id = id;
            this.label = label;
            this.run = 0;
        }

        public final DocProcessingToolConfig getToolConfig() {
            return this.config;
        }

        public final String getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public void initRun(byte run, ILaunchConfiguration configuration) throws CoreException {
            this.isEnabled = configuration.getAttribute(String.valueOf(this.getId()) + '/' + "Run.enabled", true);
            this.run = run == 1 ? (this.isEnabled ? (byte)1 : 0) : run;
        }

        public final byte getRun() {
            return this.run;
        }

        public final boolean isRun() {
            return this.run != 0;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        protected boolean resolveOutputFile() {
            return true;
        }

        public VariableText2 getVariableResolver() {
            VariableText2 variableText = this.variableText;
            if (variableText == null) {
                HashMap<String, IStringVariable> variables = new HashMap<String, IStringVariable>();
                variables.putAll(this.config.getVariables());
                this.variableText = variableText = new VariableText2(variables);
            }
            return variableText;
        }

        public void initIOFiles(IFile inputFile, ILaunchConfiguration configuration, SubMonitor m) throws CoreException {
            m.setWorkRemaining(4);
            if (inputFile == null) {
                throw new NullPointerException("inputFile");
            }
            this.setInputFile(inputFile);
            if (!this.resolveOutputFile()) {
                return;
            }
            m.worked(1);
            if (m.isCanceled()) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            String formatAttrName = String.valueOf(this.getId()) + '/' + "Output.Format.key";
            String fileAttrName = String.valueOf(this.getId()) + '/' + "Output.File.path";
            String formatKey = configuration.getAttribute(formatAttrName, null);
            if (formatKey == null) {
                throw DocProcessingToolConfig.createMissingConfigAttr(formatAttrName);
            }
            String filePath = configuration.getAttribute(fileAttrName, null);
            if (filePath == null) {
                throw DocProcessingToolConfig.createMissingConfigAttr(fileAttrName);
            }
            m.worked(1);
            if (m.isCanceled()) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            try {
                String outputExt = this.getToolConfig().getOutputExt(this, formatKey, m.newChild(1));
                Map variables = this.getVariableResolver().getExtraVariables();
                VariableUtils.add((Map)variables, (IStringVariable)new StaticVariable((IStringVariable)DocProcessingConfig.OUT_FILE_EXT_VAR, outputExt));
                m.worked(0);
                if (m.isCanceled()) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
                FileValidator validator = new FileValidator(false);
                validator.setResourceLabel("output file");
                validator.setRequireWorkspace(true, true);
                validator.setOnDirectory(4);
                validator.setRelative(this.getToolConfig().getVariables().get("wd_path"), -1);
                validator.setVariableResolver(this.getVariableResolver());
                validator.setExplicit((Object)filePath);
                if (validator.getStatus().getSeverity() == 4) {
                    throw DocProcessingToolConfig.createValidationFailed(validator);
                }
                this.setOutputFile((IFile)ObjectUtils.nonNullAssert((Object)((IFile)validator.getWorkspaceResource())));
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", NLS.bind((String)"Failed to initialize IO configuration for {0}.", (Object)this.getLabel()), (Throwable)e));
            }
        }

        protected void setInputFile(IFile file) {
            this.inputFile = (IFile)ObjectUtils.nonNullAssert((Object)file);
            this.inputFileUtil = new ResourceVariableUtil(this.getToolConfig().getSourceFileVariableUtil(), (IResource)file);
            Map variables = this.getVariableResolver().getExtraVariables();
            VariableUtils.add((Map)variables, (IStringVariable)new StaticVariable((IStringVariable)DocProcessingConfig.IN_FILE_PATH_VAR, file.getFullPath().toString()));
            VariableUtils.add((Map)variables, (Collection)ResourceVariables.getSingleResourceVariables(), (IDynamicVariableResolver)new ResourceVariableResolver((ResourceVariableResolver.Context)this.inputFileUtil, 0));
        }

        protected void setOutputFile(IFile file) {
            this.outputFile = (IFile)ObjectUtils.nonNullAssert((Object)file);
            Map variables = this.getVariableResolver().getExtraVariables();
            VariableUtils.add((Map)variables, (IStringVariable)new StaticVariable((IStringVariable)DocProcessingConfig.OUT_FILE_PATH_VAR, file.getFullPath().toString()));
        }

        public IFile getInputFile() {
            return this.inputFile;
        }

        public ResourceVariableUtil getInputFileUtil() {
            return this.inputFileUtil;
        }

        public IFile getOutputFile() {
            return this.outputFile;
        }

        public void initOperation(ILaunchConfiguration configuration, SubMonitor m) throws CoreException {
            m.setWorkRemaining(4);
            String idAttrName = String.valueOf(this.getId()) + '/' + "Operation.id";
            String settingsAttrName = String.valueOf(this.getId()) + '/' + "Operation.settings";
            String id = configuration.getAttribute(idAttrName, null);
            if (id == null) {
                throw DocProcessingToolConfig.createMissingConfigAttr(idAttrName);
            }
            if (id.isEmpty()) {
                return;
            }
            DocProcessingOperation operation = null;
            try {
                operation = this.getToolConfig().createStepOperation(id);
                if (operation == null) {
                    throw new UnsupportedOperationException("operationId= " + id);
                }
                m.worked(2);
                Map settings = (Map)ObjectUtils.nonNullAssert((Object)configuration.getAttribute(settingsAttrName, DocProcessingOperation.NO_SETTINGS));
                operation.init(this, settings, m.newChild(2));
                this.operation = operation;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", NLS.bind((String)Messages.ProcessingConfig_InitOperation_error_Failed_message, (Object)(operation != null ? operation.getLabel() : "?"), (Object)this.getLabel()), (Throwable)e));
            }
        }

        public @Nullable DocProcessingOperation getOperation() {
            return this.operation;
        }

        public void initPre(ILaunchConfiguration configuration, SubMonitor m) throws CoreException {
        }

        protected void addPre(DocProcessingOperation operation) {
            this.preOperations.add(operation);
        }

        public List<DocProcessingOperation> getPre() {
            return this.preOperations;
        }

        public void initPost(ILaunchConfiguration configuration, SubMonitor m) throws CoreException {
        }

        protected void addPost(DocProcessingOperation operation) {
            this.postOperations.add(operation);
        }

        public List<DocProcessingOperation> getPost() {
            return this.postOperations;
        }

        protected boolean isOptionEnabled(@Nullable String key) {
            if (key == null) {
                return false;
            }
            switch (key) {
                case "always": {
                    return this.isRun();
                }
                case "step_only": {
                    return this.getRun() == 2;
                }
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("StepConfig");
            sb.append(" {").append("id= ").append(this.getId()).append("}");
            return sb.toString();
        }
    }
}

