/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core;

import java.util.ConcurrentModificationException;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ContentLineSequence;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.LineSequence;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
class LookAheadLineSequence
extends LineSequence {
    private final ContentLineSequence lineSequence;
    private @Nullable Line currentLine;
    private final @Nullable Line referenceLine;
    private int index;

    public LookAheadLineSequence(ContentLineSequence lineSequence) {
        this.lineSequence = lineSequence;
        this.referenceLine = this.currentLine = lineSequence.getCurrentLine();
        this.index = -1;
    }

    public LookAheadLineSequence(LookAheadLineSequence lookAheadLineSequence) {
        this.lineSequence = lookAheadLineSequence.lineSequence;
        this.currentLine = lookAheadLineSequence.currentLine;
        this.referenceLine = lookAheadLineSequence.referenceLine;
        this.index = lookAheadLineSequence.index;
    }

    @Override
    public LineSequence lookAhead() {
        return new LookAheadLineSequence(this);
    }

    @Override
    public @Nullable Line getCurrentLine() {
        return this.currentLine;
    }

    @Override
    public @Nullable Line getNextLine() {
        this.checkConcurrentModification();
        return this.lineSequence.getNextLine(this.index + 1);
    }

    @Override
    public void advance() {
        this.checkConcurrentModification();
        this.currentLine = this.getNextLine();
        ++this.index;
    }

    private void checkConcurrentModification() {
        if (this.referenceLine != this.lineSequence.getCurrentLine()) {
            throw new ConcurrentModificationException();
        }
    }
}

