/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.Locator;
import org.eclipse.statet.docmlet.wikitext.commonmark.core.ParseHelper;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonmarkLocator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.LineSequence;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockNode;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockType;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class SourceBlocks {
    private final ImList<SourceBlockType<?>> supportedTypes;

    public SourceBlocks(ImList<SourceBlockType<?>> supportedTypes) {
        this.supportedTypes = (ImList)ObjectUtils.nonNullAssert(supportedTypes);
    }

    public List<SourceBlockNode<?>> createNodes(LineSequence lineSequence, final ParseHelper parseHelper) {
        final ArrayList nodes = new ArrayList();
        SourceBlockBuilder sourceBlockBuilder = new SourceBlockBuilder(this, lineSequence, this.supportedTypes){

            @Override
            public ParseHelper getParseHelper() {
                return parseHelper;
            }

            @Override
            public void accept(SourceBlockNode<?> node) {
                nodes.add(node);
            }
        };
        sourceBlockBuilder.run();
        return nodes;
    }

    public void parseSourceStruct(final ProcessingContext context, LineSequence lineSequence, final DocumentBuilder builder) {
        context.setMode(3);
        final CommonmarkLocator locator = new CommonmarkLocator();
        builder.setLocator((Locator)locator);
        SourceBlockBuilder sourceBlockBuilder = new SourceBlockBuilder(this, lineSequence, this.supportedTypes){

            @Override
            public ParseHelper getParseHelper() {
                return context.getHelper();
            }

            @Override
            public void accept(SourceBlockNode<?> node) {
                ((SourceBlockType)node.getType()).emit(context, node, locator, builder);
            }
        };
        sourceBlockBuilder.run();
    }

    public void initializeContext(ProcessingContext context, List<SourceBlockNode<?>> nodes) {
        context.setMode(1);
        for (SourceBlockNode<?> node : nodes) {
            ((SourceBlockType)node.getType()).initializeContext(context, node);
        }
    }

    public void emit(ProcessingContext context, List<SourceBlockNode<?>> nodes, DocumentBuilder builder) {
        context.setMode(2);
        CommonmarkLocator locator = new CommonmarkLocator();
        builder.setLocator((Locator)locator);
        for (SourceBlockNode<?> node : nodes) {
            ((SourceBlockType)node.getType()).emit(context, node, locator, builder);
        }
    }

    public @Nullable SourceBlockType<?> selectBlock(LineSequence lineSequence, SourceBlockNode<?> currentNode) {
        return this.selectBlock(lineSequence, this.supportedTypes, currentNode);
    }

    public @Nullable SourceBlockType<?> selectBlock(LineSequence lineSequence) {
        return this.selectBlock(lineSequence, this.supportedTypes, null);
    }

    public @Nullable SourceBlockType<?> selectBlock(LineSequence lineSequence, ImList<? extends SourceBlockType<?>> supportedTypes, @Nullable SourceBlockNode<?> currentNode) {
        for (SourceBlockType candidate : supportedTypes) {
            if (!candidate.canStart(lineSequence, currentNode)) continue;
            return candidate;
        }
        return null;
    }

    private static class CollectLineSequence
    extends LineSequence {
        private final LineSequence delegate;
        private @Nullable Line currentLine;
        private final List<Line> lines = new ArrayList<Line>();

        public CollectLineSequence(LineSequence delegate) {
            this.delegate = delegate;
        }

        @Override
        public LineSequence lookAhead() {
            return this.delegate.lookAhead();
        }

        @Override
        public LineSequence lookAhead(int lineNumber) {
            return this.delegate.lookAhead(lineNumber);
        }

        @Override
        public @Nullable Line getCurrentLine() {
            this.currentLine = this.delegate.getCurrentLine();
            return this.currentLine;
        }

        @Override
        public @Nullable Line getNextLine() {
            return this.delegate.getNextLine();
        }

        @Override
        public void advance() {
            Line line = this.currentLine;
            if (line == null) {
                line = this.delegate.getCurrentLine();
            } else {
                this.currentLine = null;
            }
            this.delegate.advance();
            if (line != null) {
                this.lines.add(line);
            }
        }

        public ImList<Line> getLines() {
            return ImCollections.toList(this.lines);
        }

        public void reset() {
            this.lines.clear();
        }
    }

    public abstract class SourceBlockBuilder {
        private final CollectLineSequence collectLineSequence;
        private @Nullable SourceBlockNode<?> currentNode;
        private final ImList<? extends SourceBlockType<?>> supportedTypes;
        private @Nullable SourceBlockBuilder nested;

        private SourceBlockBuilder(LineSequence lineSequence, ImList<? extends SourceBlockType<?>> supportedTypes) {
            this.collectLineSequence = new CollectLineSequence(lineSequence);
            this.supportedTypes = supportedTypes;
        }

        public abstract ParseHelper getParseHelper();

        public LineSequence getLineSequence() {
            return this.collectLineSequence;
        }

        public SourceBlocks getSourceBlocks() {
            return SourceBlocks.this;
        }

        public @Nullable SourceBlockBuilder getParent() {
            return null;
        }

        public SourceBlockNode<?> getCurrentNode() {
            return this.currentNode;
        }

        public @Nullable SourceBlockBuilder getActiveLeaf() {
            SourceBlockBuilder active = null;
            SourceBlockBuilder candidate = this.nested;
            while (candidate != null && candidate.currentNode != null) {
                active = candidate;
                candidate = candidate.nested;
            }
            return active;
        }

        public @Nullable SourceBlockNode<?> getParentNode() {
            SourceBlockBuilder parent = this.getParent();
            return parent != null ? parent.currentNode : null;
        }

        public @Nullable SourceBlockNode<?> getActiveNode() {
            SourceBlockBuilder active = this.getActiveLeaf();
            return active != null ? active.currentNode : null;
        }

        public void createNestedNodes(LineSequence lineSequence, @Nullable ImList<? extends SourceBlockType<?>> supportedTypes) {
            try {
                SourceBlockBuilder nested;
                this.nested = nested = new SourceBlockBuilder(SourceBlocks.this, lineSequence, supportedTypes != null ? supportedTypes : this.getSourceBlocks().supportedTypes){

                    @Override
                    public @Nullable SourceBlockBuilder getParent() {
                        return SourceBlockBuilder.this;
                    }

                    @Override
                    public ParseHelper getParseHelper() {
                        return SourceBlockBuilder.this.getParseHelper();
                    }
                };
                nested.run();
            }
            finally {
                this.nested = null;
            }
        }

        void beginNode(SourceBlockNode<?> node) {
            this.finishNode();
            this.currentNode = node;
        }

        void finishNode() {
            SourceBlockNode<?> node = this.currentNode;
            if (node != null) {
                this.currentNode = null;
                node.setLines(this.collectLineSequence.getLines());
                this.collectLineSequence.reset();
                this.accept(node);
            }
        }

        void accept(SourceBlockNode<?> node) {
        }

        void run() {
            while (this.collectLineSequence.getCurrentLine() != null) {
                SourceBlockType<?> block = SourceBlocks.this.selectBlock(this.collectLineSequence, this.supportedTypes, null);
                if (block != null) {
                    block.createNodes(this);
                    this.finishNode();
                    continue;
                }
                return;
            }
        }
    }
}

