/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import java.util.Locale;
import org.eclipse.statet.ecommons.collections.FastList;
import org.eclipse.statet.ecommons.ui.components.IObjValueListener;
import org.eclipse.statet.ecommons.ui.components.IObjValueWidget;
import org.eclipse.statet.ecommons.ui.components.ObjValueEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class DoubleText
implements IObjValueWidget<Double> {
    private final Text fText;
    private Double fValue;
    private final FastList<IObjValueListener<Double>> fValueListeners = new FastList(IObjValueListener.class);
    private double fIncrement;
    private double fMin;
    private double fMax = Double.NaN;
    private DecimalFormat fFormat;

    public static DecimalFormat createFormat(int maxDigits) {
        DecimalFormat format = new DecimalFormat("0.0");
        format.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance((Locale)Locale.ENGLISH));
        format.setMaximumFractionDigits(maxDigits);
        format.setRoundingMode(5);
        return format;
    }

    public DoubleText(Composite parent, int flags) {
        this.fText = new Text(parent, 0x4004 | flags);
        SWTListener swtListener = new SWTListener();
        this.fText.addListener(24, (Listener)swtListener);
        this.fText.addListener(1, (Listener)swtListener);
    }

    public Text getControl() {
        return this.fText;
    }

    @Override
    public Class<Double> getValueType() {
        return Double.class;
    }

    public void setIncrement(double v) {
        this.fIncrement = v;
    }

    public void setMinMax(double min, double max) {
        if (Double.isNaN(min) || Double.isNaN(max)) {
            this.fMin = 0.0;
            this.fMax = Double.NaN;
        } else {
            this.fMin = min;
            this.fMax = max;
        }
    }

    public void setFormat(DecimalFormat format) {
        this.fFormat = format;
    }

    @Override
    public void addValueListener(IObjValueListener<Double> listener) {
        this.fValueListeners.add(listener);
    }

    @Override
    public void removeValueListener(IObjValueListener<Double> listener) {
        this.fValueListeners.remove(listener);
    }

    @Override
    public Double getValue(int idx) {
        return this.fValue;
    }

    @Override
    public void setValue(int idx, Double value) {
        this.fText.setText(this.formatValue(value));
    }

    private void incrementValue(double increment) {
        double newValue;
        double d = newValue = this.fValue != null ? this.fValue + increment : this.fMin;
        if (!Double.isNaN(this.fMax)) {
            if (newValue < this.fMin) {
                newValue = this.fMin;
            } else if (newValue > this.fMax) {
                newValue = this.fMax;
            }
        }
        this.fText.setText(this.formatValue(newValue));
    }

    protected Double parseValue(String text) {
        try {
            return Double.valueOf(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected String formatValue(Double value) {
        if (value == null) {
            return "";
        }
        if (this.fFormat != null) {
            return this.fFormat.format(value.doubleValue());
        }
        return value.toString();
    }

    private void updateValue(int time) {
        Double newValue = this.parseValue(this.fText.getText());
        if (newValue != null ? newValue.equals(this.fValue) : this.fValue == null) {
            return;
        }
        IObjValueListener[] listeners = (IObjValueListener[])this.fValueListeners.toArray();
        ObjValueEvent<Double> event = new ObjValueEvent<Double>(this, time, 0, this.fValue, newValue, 0);
        this.fValue = newValue;
        int i = 0;
        while (i < listeners.length) {
            event.newValue = newValue;
            listeners[i].valueChanged(event);
            ++i;
        }
    }

    private class SWTListener
    implements Listener {
        private SWTListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 24: {
                    DoubleText.this.updateValue(event.time);
                    return;
                }
                case 1: {
                    switch (event.keyCode) {
                        case 0x1000001: {
                            DoubleText.this.incrementValue(DoubleText.this.fIncrement);
                            event.doit = false;
                            return;
                        }
                        case 0x1000002: {
                            DoubleText.this.incrementValue(-DoubleText.this.fIncrement);
                            event.doit = false;
                            return;
                        }
                        case 0x1000005: {
                            DoubleText.this.incrementValue(DoubleText.this.fIncrement * 10.0);
                            event.doit = false;
                            return;
                        }
                        case 0x1000006: {
                            DoubleText.this.incrementValue(-DoubleText.this.fIncrement * 10.0);
                            event.doit = false;
                            return;
                        }
                    }
                }
            }
        }
    }
}

