/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

public class TreeAndListGroup
implements ISelectionChangedListener {
    private Object fRoot;
    private Object fCurrentTreeSelection;
    private final ListenerList fSelectionChangedListeners = new ListenerList();
    private final ListenerList fDoubleClickListeners = new ListenerList();
    private final ITreeContentProvider fTreeContentProvider;
    private final IStructuredContentProvider fListContentProvider;
    private final ILabelProvider fTreeLabelProvider;
    private final ILabelProvider fListLabelProvider;
    private final ViewerComparator fComparator;
    private final Composite fControl;
    private SashForm fSplitControl;
    private TreeViewer fTreeViewer;
    private TableViewer fListViewer;
    private boolean fAllowMultiselection = false;

    public TreeAndListGroup(Composite parent, Object rootObject, ITreeContentProvider treeContentProvider, ILabelProvider treeLabelProvider, IStructuredContentProvider listContentProvider, ILabelProvider listLabelProvider, ViewerComparator comparator, boolean allowMultiselection) {
        this.fRoot = rootObject;
        this.fTreeContentProvider = treeContentProvider;
        this.fListContentProvider = listContentProvider;
        this.fTreeLabelProvider = treeLabelProvider;
        this.fListLabelProvider = listLabelProvider;
        this.fComparator = comparator;
        this.fAllowMultiselection = allowMultiselection;
        this.fControl = this.createControls(parent);
    }

    public Composite getControl() {
        return this.fControl;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.add((Object)listener);
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.fDoubleClickListeners.add((Object)listener);
    }

    protected void notifySelectionListeners(SelectionChangedEvent event) {
        Object[] objectArray = this.fSelectionChangedListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            ((ISelectionChangedListener)o).selectionChanged(event);
            ++n2;
        }
    }

    protected void notifyDoubleClickListeners(DoubleClickEvent event) {
        Object[] objectArray = this.fDoubleClickListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            ((IDoubleClickListener)o).doubleClick(event);
            ++n2;
        }
    }

    protected Composite createControls(Composite parent) {
        this.fSplitControl = new SashForm(parent, 256);
        this.fSplitControl.setVisible(true);
        this.fSplitControl.setFont(parent.getFont());
        this.createTreeViewer((Composite)this.fSplitControl);
        this.createListViewer((Composite)this.fSplitControl);
        this.fSplitControl.setWeights(new int[]{1, 1});
        return this.fSplitControl;
    }

    protected void createListViewer(Composite parent) {
        int style = this.fAllowMultiselection ? 2 : 4;
        this.fListViewer = new TableViewer(parent, 0x800 | style);
        GridData data = new GridData(1808);
        this.fListViewer.getTable().setLayoutData((Object)data);
        this.fListViewer.getTable().setFont(parent.getFont());
        this.fListViewer.setContentProvider((IContentProvider)this.fListContentProvider);
        this.fListViewer.setLabelProvider((IBaseLabelProvider)this.fListLabelProvider);
        this.fListViewer.setComparator(this.fComparator);
        this.fListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeAndListGroup.this.notifySelectionListeners(event);
            }
        });
        this.fListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!event.getSelection().isEmpty()) {
                    TreeAndListGroup.this.notifyDoubleClickListeners(event);
                }
            }
        });
    }

    protected void createTreeViewer(Composite parent) {
        Tree tree = new Tree(parent, 2048);
        GridData data = new GridData(1808);
        tree.setLayoutData((Object)data);
        tree.setFont(parent.getFont());
        this.fTreeViewer = new TreeViewer(tree);
        this.fTreeViewer.setContentProvider((IContentProvider)this.fTreeContentProvider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.fTreeLabelProvider);
        this.fTreeViewer.setComparator(this.fComparator);
        this.fTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public Table getListTable() {
        return this.fListViewer.getTable();
    }

    public IStructuredSelection getListSelection() {
        ISelection selection = this.fListViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    public void selectListElement(Object element) {
        Object parent = this.fTreeContentProvider.getParent(element);
        this.fTreeViewer.setSelection((ISelection)new StructuredSelection(parent), true);
        this.fListViewer.setSelection((ISelection)new StructuredSelection(element), true);
    }

    public void selectTreeElement(Object element) {
        this.fTreeViewer.setSelection((ISelection)new StructuredSelection(element), true);
    }

    public void initFields() {
        this.fTreeViewer.setInput(this.fRoot);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object selectedElement = selection.getFirstElement();
        if (selectedElement != this.fCurrentTreeSelection) {
            this.fCurrentTreeSelection = selectedElement;
            this.fListViewer.setInput(selectedElement);
            this.notifySelectionListeners(event);
        }
    }

    public void setListProviders(IStructuredContentProvider contentProvider, ILabelProvider labelProvider) {
        this.fListViewer.setContentProvider((IContentProvider)contentProvider);
        this.fListViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public void setListSorter(ViewerSorter sorter) {
        this.fListViewer.setSorter(sorter);
    }

    public void setRoot(Object newRoot) {
        this.fRoot = newRoot;
        this.initFields();
    }

    public void setTreeProviders(ITreeContentProvider contentProvider, ILabelProvider labelProvider) {
        this.fTreeViewer.setContentProvider((IContentProvider)contentProvider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public void setTreeSorter(ViewerSorter sorter) {
        this.fTreeViewer.setSorter(sorter);
    }

    public void setFocus() {
        this.fTreeViewer.getTree().setFocus();
    }
}

