/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Geometry;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class ToolPopup {
    private static final Color G_BACKGROUND = SharedUIResources.getColors().getColor("graphics.background");
    private Shell fShell;
    private CTabFolder fTabFolder;
    private Button fOKButton;
    private Button fCancelButton;
    private final List<ToolTab> fToolTabs = new ArrayList<ToolTab>();
    private int fIgnoreActivation;

    protected void open(Shell parent, Rectangle position) {
        this.create(parent);
        Point size = this.fShell.getSize();
        Display display = this.fShell.getDisplay();
        Monitor monitor = DialogUtils.getClosestMonitor(display, position);
        Rectangle clientArea = monitor.getClientArea();
        Rectangle bounds = new Rectangle(position.x, position.y - size.y, size.x, size.y);
        if (bounds.y < 0) {
            bounds.y = position.y + position.height;
        }
        Geometry.moveInside((Rectangle)bounds, (Rectangle)clientArea);
        this.fShell.setBounds(bounds);
        this.selectTab(this.getBestTab());
        this.fShell.open();
    }

    public boolean isActive() {
        return UIAccess.isOkToUse((Control)this.fShell) && this.fShell.isVisible();
    }

    public void close() {
        if (UIAccess.isOkToUse((Control)this.fShell)) {
            this.fShell.close();
        }
        this.dispose();
    }

    public void dispose() {
        if (this.fShell != null) {
            if (!this.fShell.isDisposed()) {
                this.fShell.dispose();
            }
            this.onDispose();
            this.fShell = null;
        }
    }

    private void create(Shell parent) {
        if (UIAccess.isOkToUse((Control)this.fShell)) {
            if (this.fShell.getParent() == parent) {
                return;
            }
            this.dispose();
        }
        this.fToolTabs.clear();
        this.fShell = new Shell(parent, 16388);
        this.fShell.setText("Color");
        this.fShell.setFont(JFaceResources.getDialogFont());
        this.fShell.setSize(320, 300);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        this.fShell.setLayout((Layout)gl);
        SWTListener listener = new SWTListener();
        parent.addListener(12, (Listener)listener);
        this.fShell.addListener(27, (Listener)listener);
        this.fShell.setBackground(this.fShell.getDisplay().getSystemColor(22));
        this.fShell.setBackgroundMode(2);
        this.fTabFolder = new CTabFolder((Composite)this.fShell, 0x800400);
        this.fTabFolder.setSimple(true);
        this.fTabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTabFolder.setSelectionBackground(G_BACKGROUND);
        this.addTabs(this.fTabFolder);
        Composite commonBar = new Composite((Composite)this.fShell, 0);
        commonBar.setLayoutData((Object)new GridData(4, 4, true, false));
        commonBar.setLayout((Layout)LayoutUtils.newContentGrid(3));
        this.addStatusControls(commonBar);
        this.fOKButton = new Button(commonBar, 0x800008);
        this.fOKButton.setText(IDialogConstants.OK_LABEL);
        this.fOKButton.setFont(this.fShell.getFont());
        this.fOKButton.addListener(13, (Listener)listener);
        this.fCancelButton = new Button(commonBar, 0x800008);
        this.fCancelButton.setText(IDialogConstants.CANCEL_LABEL);
        this.fCancelButton.setFont(this.fShell.getFont());
        this.fCancelButton.addListener(13, (Listener)listener);
        Point size = this.fOKButton.computeSize(-1, -1, true);
        size.x = Math.max(size.x, this.fCancelButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        GridData gd = new GridData(4, 4);
        gd.widthHint = size.x;
        gd.heightHint = size.y - 2;
        this.fOKButton.setLayoutData((Object)gd);
        gd = new GridData(4, 4);
        gd.widthHint = size.x;
        gd.heightHint = size.y - 2;
        this.fCancelButton.setLayoutData((Object)gd);
        this.fTabFolder.addListener(13, (Listener)listener);
        this.fShell.setDefaultButton(this.fOKButton);
        this.fShell.pack();
    }

    public Shell getShell() {
        return this.fShell;
    }

    protected CTabFolder getTabFolder() {
        return this.fTabFolder;
    }

    protected ToolTab getTab(String key) {
        for (ToolTab tab : this.fToolTabs) {
            if (tab.fKey != key) continue;
            return tab;
        }
        return null;
    }

    protected ToolTab getTab(CTabItem item) {
        for (ToolTab tab : this.fToolTabs) {
            if (tab.fTabItem != item) continue;
            return tab;
        }
        return null;
    }

    protected void addStatusControls(Composite composite) {
    }

    protected void addTabs(CTabFolder tabFolder) {
    }

    protected ToolTab getBestTab() {
        return null;
    }

    protected void selectTab(ToolTab tab) {
        if (tab != null) {
            final CTabItem tabItem = tab.getTabItem();
            this.fTabFolder.setSelection(tabItem);
            this.tabSelected(tab);
            final Display display = this.fShell.getDisplay();
            final Control focusControl = display.getFocusControl();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (UIAccess.isOkToUse((Control)ToolPopup.this.fTabFolder) && ToolPopup.this.fTabFolder.getSelection() == tabItem && display.getFocusControl() == focusControl) {
                        tabItem.getControl().setFocus();
                    }
                }
            });
        }
    }

    protected void tabSelected(ToolTab tab) {
        if (tab != null) {
            tab.activated();
            tab.getTabItem().getControl().setFocus();
        }
    }

    public void beginIgnoreActivation() {
        ++this.fIgnoreActivation;
    }

    public void endIgnoreActivation() {
        --this.fIgnoreActivation;
    }

    protected void onDispose() {
        this.fTabFolder = null;
        this.fToolTabs.clear();
    }

    protected void onOK() {
    }

    protected static abstract class PreviewCanvas
    extends Canvas
    implements PaintListener {
        private static final int DEFAULT_WIDTH = 50;

        public PreviewCanvas(Composite parent) {
            super(parent, 0);
            this.addPaintListener(this);
            this.setLayoutData(this.createGD());
        }

        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            gc.setForeground(e.display.getSystemColor(16));
            Rectangle size = this.getClientArea();
            int width = Math.min(50, size.width / 2);
            int height = size.height - 7;
            int x0 = size.x;
            int y0 = size.y + (size.height - height) / 2;
            gc.drawRectangle(x0, y0, width, height);
            gc.drawRectangle(x0 + width, y0, width, height);
            this.drawPreview(gc, 0, x0 + 1, y0 + 1, width - 2, height - 2);
            this.drawPreview(gc, 1, x0 + width + 1, y0 + 1, width - 2, height - 2);
        }

        public GridData createGD() {
            return new GridData(4, 4, true, false);
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            int width = 101;
            if (wHint != -1 && wHint < width) {
                width = Math.max(width / 2, wHint);
            }
            int height = hHint != -1 ? hHint : 4 + LayoutUtils.defaultHSpacing();
            return new Point(width, height);
        }

        protected abstract void drawPreview(GC var1, int var2, int var3, int var4, int var5, int var6);
    }

    private class SWTListener
    implements Listener {
        private SWTListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 27: {
                    if (ToolPopup.this.fIgnoreActivation == 0) {
                        ToolPopup.this.close();
                    }
                    return;
                }
                case 12: {
                    ToolPopup.this.dispose();
                    return;
                }
                case 13: {
                    if (event.widget == ToolPopup.this.fOKButton) {
                        ToolPopup.this.onOK();
                        ToolPopup.this.close();
                        return;
                    }
                    if (event.widget == ToolPopup.this.fCancelButton) {
                        ToolPopup.this.close();
                        return;
                    }
                    if (event.widget != ToolPopup.this.fTabFolder) break;
                    ToolPopup.this.tabSelected(ToolPopup.this.getTab(ToolPopup.this.fTabFolder.getSelection()));
                    return;
                }
            }
        }
    }

    public static class ToolTab {
        private final String fKey;
        private final ToolPopup fParent;
        private final CTabItem fTabItem;
        private Composite fComposite;

        public ToolTab(String key, ToolPopup parent, String name, String tooltip) {
            this.fKey = key;
            this.fParent = parent;
            this.fTabItem = new CTabItem(parent.fTabFolder, 0);
            this.fTabItem.setText(name);
            this.fTabItem.setToolTipText(tooltip);
            parent.fToolTabs.add(this);
        }

        public ToolPopup getParent() {
            return this.fParent;
        }

        public CTabItem getTabItem() {
            return this.fTabItem;
        }

        protected Composite create() {
            Composite composite = new Composite((Composite)this.fParent.getTabFolder(), 0);
            this.fTabItem.setControl((Control)composite);
            composite.setBackground(G_BACKGROUND);
            return composite;
        }

        protected void activated() {
        }

        protected void performOK() {
            this.fParent.onOK();
            this.fParent.close();
        }
    }
}

