/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.workbench;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.statet.ecommons.ui.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class DecoratingStyledLabelProvider
extends DecoratingStyledCellLabelProvider
implements IPropertyChangeListener {
    public static final Collection<String> DEFAULT_UPDATE_PROPERTIES;
    private Collection<String> updateProperties = DEFAULT_UPDATE_PROPERTIES;

    static {
        HashSet<String> properties = new HashSet<String>();
        properties.add("USE_COLORED_LABELS");
        properties.add("QUALIFIER_COLOR");
        properties.add("COUNTER_COLOR");
        properties.add("DECORATIONS_COLOR");
        DEFAULT_UPDATE_PROPERTIES = Collections.unmodifiableSet(properties);
    }

    public static boolean showColoredLabels() {
        return PlatformUI.getPreferenceStore().getBoolean("USE_COLORED_LABELS");
    }

    public DecoratingStyledLabelProvider(DelegatingStyledCellLabelProvider.IStyledLabelProvider provider) {
        super(provider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null);
    }

    public DecoratingStyledLabelProvider(DelegatingStyledCellLabelProvider.IStyledLabelProvider provider, Collection<String> updateProperties) {
        super(provider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null);
        this.updateProperties = updateProperties;
    }

    protected void setUpdateProperties(Collection<String> properties) {
        this.updateProperties = properties;
    }

    protected Collection<String> getUpdateProperties() {
        return this.updateProperties;
    }

    public void initialize(ColumnViewer viewer, ViewerColumn column) {
        PlatformUI.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getColorRegistry().addListener((IPropertyChangeListener)this);
        this.setOwnerDrawEnabled(DecoratingStyledLabelProvider.showColoredLabels());
        super.initialize(viewer, column);
    }

    @Override
    public void dispose() {
        PlatformUI.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getColorRegistry().removeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    private void refresh() {
        ColumnViewer viewer = this.getViewer();
        if (viewer == null) {
            return;
        }
        boolean updateRequired = false;
        boolean showColoredLabels = DecoratingStyledLabelProvider.showColoredLabels();
        if (showColoredLabels != this.isOwnerDrawEnabled()) {
            this.setOwnerDrawEnabled(showColoredLabels);
            updateRequired = true;
        } else if (showColoredLabels) {
            updateRequired = true;
        }
        if (updateRequired) {
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.updateProperties.contains(event.getProperty())) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DecoratingStyledLabelProvider.this.refresh();
                }
            });
        }
    }

    protected StyleRange prepareStyleRange(StyleRange styleRange, boolean applyColors) {
        if (!applyColors && styleRange.background != null) {
            styleRange = super.prepareStyleRange(styleRange, applyColors);
            styleRange.borderStyle = 4;
            return styleRange;
        }
        return super.prepareStyleRange(styleRange, applyColors);
    }
}

