/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.workbench.workspace;

import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.statet.ecommons.resources.core.variables.ResourceVariableResolver;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;

@NonNullByDefault
public class ResourceVariableUtil
implements ResourceVariableResolver.Context {
    protected static final byte S_RESOURCE_FETCHED = 1;
    private final IWorkbenchPage workbenchPage;
    private final @Nullable IWorkbenchPart part;
    private byte state;
    private @Nullable IResource resource;

    public static @Nullable IResource fetchSelectedResource() {
        return ResourceVariableUtil.fetchSelectedResource(null);
    }

    private static @Nullable IResource fetchSelectedResource(@Nullable IWorkbenchPart part) {
        Display display = UIAccess.getDisplay();
        if (Thread.currentThread() == display.getThread()) {
            return ResourceVariableUtil.getSelectedResource0(part);
        }
        class DisplayRunnable
        implements Runnable {
            @Nullable IResource resource;
            private final /* synthetic */ IWorkbenchPart val$part;

            DisplayRunnable(IWorkbenchPart iWorkbenchPart) {
                this.val$part = iWorkbenchPart;
            }

            @Override
            public void run() {
                this.resource = ResourceVariableUtil.getSelectedResource0(this.val$part);
            }
        }
        DisplayRunnable runnable = new DisplayRunnable(part);
        display.syncExec((Runnable)runnable);
        return runnable.resource;
    }

    private static @Nullable IResource getSelectedResource0(@Nullable IWorkbenchPart part) {
        IWorkbenchPage page;
        IResource resource = null;
        if (part == null && (page = UIAccess.getActiveWorkbenchPage(true)) != null) {
            part = page.getActivePart();
        }
        if (part != null) {
            IStructuredSelection structuredSelection;
            ISelection selection;
            ISelectionProvider provider;
            IWorkbenchPartSite site;
            if (part instanceof IEditorPart) {
                IEditorPart epart = (IEditorPart)part;
                resource = (IResource)epart.getEditorInput().getAdapter(IResource.class);
            }
            if (resource == null && (site = part.getSite()) != null && (provider = site.getSelectionProvider()) != null && (selection = provider.getSelection()) instanceof IStructuredSelection && !(structuredSelection = (IStructuredSelection)selection).isEmpty()) {
                Iterator iterator = structuredSelection.iterator();
                IAdapterManager adapterManager = Platform.getAdapterManager();
                while (resource == null && iterator.hasNext()) {
                    Object element = iterator.next();
                    resource = (IResource)adapterManager.getAdapter(element, IResource.class);
                }
            }
        }
        return resource;
    }

    public ResourceVariableUtil() {
        this(UIAccess.getActiveWorkbenchPage(true));
    }

    public ResourceVariableUtil(IWorkbenchPage page) {
        this.workbenchPage = page;
        this.part = this.workbenchPage.getActivePart();
    }

    public ResourceVariableUtil(IWorkbenchPart part) {
        this.workbenchPage = part.getSite().getPage();
        this.part = part;
    }

    public ResourceVariableUtil(@Nullable IResource resource) {
        this();
        this.state = (byte)(this.state | 1);
        this.resource = resource;
    }

    public ResourceVariableUtil(ResourceVariableUtil location, @Nullable IResource resource) {
        this.workbenchPage = location.getWorkbenchPage();
        this.part = location.getWorkbenchPart();
        this.state = (byte)(this.state | 1);
        this.resource = resource;
    }

    public IWorkbenchPage getWorkbenchPage() {
        return this.workbenchPage;
    }

    public @Nullable IWorkbenchPart getWorkbenchPart() {
        return this.part;
    }

    public @Nullable IResource getResource() {
        if ((this.state & 1) == 0) {
            this.state = (byte)(this.state | 1);
            this.resource = this.fetchResource();
        }
        return this.resource;
    }

    protected void resetResource() {
        this.state = (byte)(this.state & 0xFFFFFFFE);
        this.resource = null;
    }

    protected @Nullable IResource fetchResource() {
        return ResourceVariableUtil.fetchSelectedResource(this.getWorkbenchPart());
    }
}

