/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.runtime;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.statet.jcommons.collections.CollectionUtils;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.runtime.AppEnvironment;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.runtime.bundle.BundleEntry;
import org.eclipse.statet.jcommons.runtime.bundle.BundleResolver;
import org.eclipse.statet.jcommons.runtime.bundle.BundleSpec;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.MultiStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.StatusLogger;

@NonNullByDefault
public abstract class BasicAppEnvironment
implements AppEnvironment {
    private final String envId;
    private final CopyOnWriteArraySet<Disposable> stoppingListeners = new CopyOnWriteArraySet();
    private final StatusLogger statusLogger;
    private final @Nullable ImList<? extends BundleResolver> bundleResolvers;

    public BasicAppEnvironment(String envId, StatusLogger statusLogger, List<? extends BundleResolver> bundleResolvers) {
        this.envId = ObjectUtils.nonNullAssert(envId);
        this.statusLogger = statusLogger;
        this.bundleResolvers = ImCollections.toNonNullList(bundleResolvers);
    }

    public BasicAppEnvironment(String envId, StatusLogger statusLogger, BundleResolver bundleResolver) {
        this.envId = ObjectUtils.nonNullAssert(envId);
        this.statusLogger = statusLogger;
        this.bundleResolvers = ImCollections.newList(ObjectUtils.nonNullAssert(bundleResolver));
    }

    public BasicAppEnvironment(String envId, StatusLogger statusLogger) {
        this.envId = ObjectUtils.nonNullAssert(envId);
        this.statusLogger = statusLogger;
        this.bundleResolvers = null;
    }

    @Override
    public final String getEnvId() {
        return this.envId;
    }

    protected void initJRuntimeStoppingHandler() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                BasicAppEnvironment.this.onAppStopping();
            }
        });
    }

    @Override
    public List<BundleEntry> resolveBundles(List<BundleSpec> bundleSpecs) throws StatusException {
        ImList<? extends BundleResolver> bundleResolvers = this.bundleResolvers;
        if (bundleResolvers == null) {
            throw new UnsupportedOperationException();
        }
        LinkedHashSet<BundleEntry> resolved = new LinkedHashSet<BundleEntry>();
        ArrayList<Status> statusCollector = new ArrayList<Status>();
        ArrayList<BundleSpec> missing = new ArrayList<BundleSpec>();
        for (BundleSpec bundleSpec : bundleSpecs) {
            if (this.resolveBundle(bundleResolvers, bundleSpec, resolved, statusCollector)) continue;
            missing.add(bundleSpec);
        }
        if (!statusCollector.isEmpty()) {
            ImList<Status> statusChildren = ImCollections.toList(statusCollector);
            CommonsRuntime.log(new MultiStatus("org.eclipse.statet.jcommons.util", "Status for resolving of bundles.", null, statusChildren));
            if (!missing.isEmpty()) {
                throw new StatusException(new MultiStatus("org.eclipse.statet.jcommons.util", "Failed to resolve the bundle(s): " + CollectionUtils.toString(missing, ", "), null, statusChildren));
            }
        }
        return ImCollections.toList(resolved);
    }

    public boolean resolveBundle(BundleSpec bundleSpec, LinkedHashSet<BundleEntry> resolved, List<Status> statusCollector) {
        ImList<? extends BundleResolver> bundleResolvers = this.bundleResolvers;
        if (bundleResolvers == null) {
            throw new UnsupportedOperationException();
        }
        return this.resolveBundle(bundleResolvers, bundleSpec, resolved, statusCollector);
    }

    private boolean resolveBundle(ImList<? extends BundleResolver> bundleResolvers, BundleSpec bundleSpec, LinkedHashSet<BundleEntry> resolved, List<Status> statusCollector) {
        MultiStatus status = new MultiStatus("org.eclipse.statet.jcommons.util", String.format("'%1$s':", bundleSpec.getId()));
        boolean found = false;
        for (BundleResolver bundleResolver : bundleResolvers) {
            if (!bundleResolver.resolveBundle(bundleSpec, resolved, status)) continue;
            found = true;
            break;
        }
        if (!found) {
            status.add(new ErrorStatus("org.eclipse.statet.jcommons.util", "The bundle could not be resolved."));
        }
        if (!status.getChildren().isEmpty()) {
            statusCollector.add(status);
        }
        return found;
    }

    @Override
    public void log(Status status) {
        this.statusLogger.log(status);
    }

    @Override
    public void addStoppingListener(Disposable listener) {
        this.stoppingListeners.add(listener);
    }

    @Override
    public void removeStoppingListener(Disposable listener) {
        this.stoppingListeners.remove(listener);
    }

    protected void onAppStopping() {
        for (Disposable listener : this.stoppingListeners) {
            try {
                listener.dispose();
            }
            catch (Throwable e) {
                this.log(new ErrorStatus("org.eclipse.statet.jcommons.util", "An error occured when disposing app listener.", e));
            }
        }
        this.stoppingListeners.clear();
    }

    public String toString() {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder("AppEnvironment", this.getClass());
        sb.append(' ', this.envId);
        sb.addProp("bundleResolvers", this.bundleResolvers);
        return sb.toString();
    }
}

