/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui.console;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.statet.internal.nico.ui.console.NIConsolePartition;
import org.eclipse.statet.internal.nico.ui.console.StreamProcessor;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.nico.ui.console.NIConsole;
import org.eclipse.statet.nico.ui.console.NIConsoleOutputStream;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.progress.WorkbenchJob;

public class NIConsolePartitioner
implements IConsoleDocumentPartitioner,
IDocumentPartitionerExtension {
    private final NIConsole console;
    private final String[] partitionIds;
    private AbstractDocument document;
    private boolean isConnected = false;
    private final ArrayList<NIConsolePartition> partitions = new ArrayList();
    private NIConsolePartition lastPartition;
    private final ArrayList<PendingPartition> pendingPartitions = new ArrayList();
    private int pendingTextLength;
    private ImList<PendingPartition> updatePartitions;
    private final QueueProcessingJob queueJob = new QueueProcessingJob();
    private final TrimJob trimJob = new TrimJob();
    private boolean updateInProgress;
    private final StreamProcessor streamProcessor;
    private int highWaterMark = -1;
    private int lowWaterMark = -1;
    private final Object overflowLock = new Object();

    public NIConsolePartitioner(NIConsole console, List<String> ids) {
        this.console = console;
        this.streamProcessor = new StreamProcessor(this);
        this.partitionIds = ids.toArray(new String[ids.size()]);
        this.trimJob.setRule(console.getSchedulingRule());
        this.queueJob.setRule(this.console.getSchedulingRule());
    }

    public NIConsole getConsole() {
        return this.console;
    }

    public AbstractDocument getDocument() {
        return this.document;
    }

    NIConsolePartition getLastPartition() {
        return this.lastPartition;
    }

    public void connect(IDocument doc) {
        this.document = (AbstractDocument)doc;
        this.document.setDocumentPartitioner((IDocumentPartitioner)this);
        this.isConnected = true;
    }

    public int getHighWaterMark() {
        return this.highWaterMark;
    }

    public int getLowWaterMark() {
        return this.lowWaterMark;
    }

    public void setWaterMarks(int low, int high) {
        this.lowWaterMark = low;
        this.highWaterMark = high;
        ConsolePlugin.getStandardDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                NIConsolePartitioner.this.checkBufferSize();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        ArrayList<PendingPartition> arrayList = this.pendingPartitions;
        synchronized (arrayList) {
            this.pendingPartitions.add(null);
        }
        this.queueJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.overflowLock;
        synchronized (object) {
            this.isConnected = false;
            this.document = null;
            this.partitions.clear();
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public boolean documentChanged(DocumentEvent event) {
        return this.documentChanged2(event) != null;
    }

    public String[] getLegalContentTypes() {
        return this.partitionIds;
    }

    public String getContentType(int offset) {
        return this.getPartition(offset).getType();
    }

    /*
     * Unable to fully structure code
     */
    public ITypedRegion[] computePartitioning(int offset, int length) {
        rangeEnd = offset + length;
        left = 0;
        right = this.partitions.size() - 1;
        mid = 0;
        position = null;
        if (right > 0) ** GOTO lbl25
        if (right == 0) {
            return new NIConsolePartition[]{this.partitions.get(0)};
        }
        return new NIConsolePartition[0];
lbl-1000:
        // 1 sources

        {
            mid = (left + right) / 2;
            position = this.partitions.get(mid);
            if (rangeEnd < position.getOffset()) {
                if (left == mid) {
                    right = left;
                    continue;
                }
                right = mid - 1;
                continue;
            }
            if (offset > position.getOffset() + position.getLength() - 1) {
                if (right == mid) {
                    left = right;
                    continue;
                }
                left = mid + 1;
                continue;
            }
            left = right = mid;
lbl25:
            // 6 sources

            ** while (left < right)
        }
lbl26:
        // 1 sources

        list = new ArrayList<NIConsolePartition>();
        index = left - 1;
        if (index >= 0) {
            position = this.partitions.get(index);
            while (index >= 0 && position.getOffset() + position.getLength() > offset) {
                if (--index < 0) continue;
                position = this.partitions.get(index);
            }
        }
        position = this.partitions.get(++index);
        while (index < this.partitions.size() && position.getOffset() < rangeEnd) {
            list.add(position);
            if (++index >= this.partitions.size()) continue;
            position = this.partitions.get(index);
        }
        return list.toArray(new NIConsolePartition[list.size()]);
    }

    public ITypedRegion getPartition(int offset) {
        int i = 0;
        while (i < this.partitions.size()) {
            ITypedRegion partition = this.partitions.get(i);
            int start = partition.getOffset();
            int end = start + partition.getLength();
            if (offset >= start && offset < end) {
                return partition;
            }
            ++i;
        }
        return this.lastPartition != null ? this.lastPartition : new NIConsolePartition(this.partitionIds[0], null);
    }

    private void checkBufferSize() {
        int length;
        if (this.document != null && this.highWaterMark > 0 && (length = this.document.getLength()) > this.highWaterMark && this.trimJob.getState() == 0) {
            this.trimJob.setOffset(length - this.lowWaterMark);
            this.trimJob.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBuffer() {
        Object object = this.overflowLock;
        synchronized (object) {
            this.trimJob.setOffset(-1);
            this.trimJob.schedule();
        }
    }

    public IRegion documentChanged2(DocumentEvent event) {
        if (this.document == null) {
            return null;
        }
        if (this.document.getLength() == 0) {
            this.partitions.clear();
            this.lastPartition = null;
            this.streamProcessor.clear();
            return new Region(0, 0);
        }
        if (this.updateInProgress && this.updatePartitions != null) {
            int offset = this.streamProcessor.getTextOffsetInDoc();
            NIConsolePartition partition = this.lastPartition;
            for (PendingPartition pp : this.updatePartitions) {
                if (pp == null) continue;
                int ppLen = pp.text.length();
                if (partition != null) {
                    int idx;
                    if (partition.getStream() == pp.stream) {
                        partition.setLength(offset + ppLen - partition.getOffset());
                        offset += ppLen;
                        continue;
                    }
                    if (partition.getLength() == 0 && (idx = this.partitions.lastIndexOf(partition)) >= 0) {
                        this.partitions.remove(idx);
                    }
                    partition = null;
                }
                if (ppLen <= 0) continue;
                partition = new NIConsolePartition(pp.stream.getId(), pp.stream, offset, ppLen);
                this.partitions.add(partition);
                offset += ppLen;
            }
            this.lastPartition = partition;
            this.streamProcessor.updateApplied();
        }
        return new Region(event.fOffset, event.fText.length());
    }

    private void setUpdateInProgress(boolean b) {
        this.updateInProgress = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamAppended(NIConsoleOutputStream stream, String s) throws IOException {
        if (this.document == null) {
            throw new IOException("Document is closed");
        }
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        ArrayList<PendingPartition> arrayList = this.pendingPartitions;
        synchronized (arrayList) {
            PendingPartition last;
            PendingPartition pendingPartition = last = this.pendingPartitions.size() > 0 ? this.pendingPartitions.get(this.pendingPartitions.size() - 1) : null;
            if (last != null && last.stream == stream) {
                last.append(s);
            } else {
                this.pendingPartitions.add(new PendingPartition(stream, s));
                if (this.pendingTextLength > 511) {
                    this.queueJob.schedule();
                } else {
                    this.queueJob.schedule(50L);
                }
            }
            if (this.pendingTextLength > 65535) {
                if (Display.getCurrent() == null) {
                    try {
                        this.pendingPartitions.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    this.processQueue();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueue() {
        Object object = this.overflowLock;
        synchronized (object) {
            block14: {
                int pendingLength;
                ImList pendingCopy;
                ArrayList<PendingPartition> arrayList = this.pendingPartitions;
                synchronized (arrayList) {
                    pendingCopy = ImCollections.toList(this.pendingPartitions);
                    this.pendingPartitions.clear();
                    pendingLength = this.pendingTextLength;
                    this.pendingTextLength = 0;
                    this.pendingPartitions.notifyAll();
                }
                if (pendingCopy.isEmpty()) {
                    return;
                }
                this.streamProcessor.prepareUpdate((ImList<PendingPartition>)pendingCopy, pendingLength);
                if (this.isConnected) {
                    this.setUpdateInProgress(true);
                    this.updatePartitions = pendingCopy;
                    try {
                        try {
                            this.document.replace(this.streamProcessor.getTextOffsetInDoc(), this.streamProcessor.getTextReplaceLengthInDoc(), this.streamProcessor.getText());
                        }
                        catch (BadLocationException badLocationException) {
                            this.updatePartitions = null;
                            this.setUpdateInProgress(false);
                            break block14;
                        }
                    }
                    catch (Throwable throwable) {
                        this.updatePartitions = null;
                        this.setUpdateInProgress(false);
                        throw throwable;
                    }
                    this.updatePartitions = null;
                    this.setUpdateInProgress(false);
                }
            }
            if (this.streamProcessor.wasFinished()) {
                this.console.partitionerFinished();
            }
            this.streamProcessor.updateDone();
            this.checkBufferSize();
        }
    }

    public boolean isReadOnly(int offset) {
        return true;
    }

    public StyleRange[] getStyleRanges(int offset, int length) {
        if (!this.isConnected) {
            return new StyleRange[0];
        }
        NIConsolePartition[] computedPartitions = (NIConsolePartition[])this.computePartitioning(offset, length);
        StyleRange[] styles = new StyleRange[computedPartitions.length];
        int i = 0;
        while (i < computedPartitions.length) {
            int rangeStart = Math.max(computedPartitions[i].getOffset(), offset);
            int rangeLength = computedPartitions[i].getLength();
            styles[i] = new StyleRange(rangeStart, rangeLength, computedPartitions[i].getStream().getColor(), computedPartitions[i].getStream().getBackgroundColor(), computedPartitions[i].getStream().getFontStyle());
            ++i;
        }
        return styles;
    }

    final class PendingPartition {
        private final NIConsoleOutputStream stream;
        private final StringBuilder text;

        PendingPartition(NIConsoleOutputStream stream, String text) {
            this.stream = stream;
            this.text = new StringBuilder(Math.max(4, 2 + text.length() / 1014) * 1024);
            this.append(text);
        }

        public NIConsoleOutputStream getStream() {
            return this.stream;
        }

        public StringBuilder getText() {
            return this.text;
        }

        private void append(String text) {
            this.text.append(text);
            NIConsolePartitioner nIConsolePartitioner = NIConsolePartitioner.this;
            nIConsolePartitioner.pendingTextLength = nIConsolePartitioner.pendingTextLength + text.length();
        }
    }

    private class QueueProcessingJob
    extends WorkbenchJob {
        QueueProcessingJob() {
            super("IOConsole Updater");
            this.setSystem(true);
            this.setPriority(10);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            NIConsolePartitioner.this.processQueue();
            return Status.OK_STATUS;
        }

        public boolean shouldRun() {
            boolean shouldRun = NIConsolePartitioner.this.isConnected && NIConsolePartitioner.this.pendingPartitions.size() > 0;
            return shouldRun;
        }
    }

    private class TrimJob
    extends WorkbenchJob {
        private int truncateOffset;

        TrimJob() {
            super("Trim Job");
            this.setSystem(true);
        }

        public void setOffset(int offset) {
            this.truncateOffset = offset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            IJobManager jobManager = Job.getJobManager();
            try {
                jobManager.join((Object)NIConsolePartitioner.this.console, monitor);
            }
            catch (OperationCanceledException e1) {
                return Status.CANCEL_STATUS;
            }
            catch (InterruptedException e1) {
                return Status.CANCEL_STATUS;
            }
            if (NIConsolePartitioner.this.document == null) {
                return Status.OK_STATUS;
            }
            int length = NIConsolePartitioner.this.document.getLength();
            if (this.truncateOffset < length) {
                Object object = NIConsolePartitioner.this.overflowLock;
                synchronized (object) {
                    try {
                        if (this.truncateOffset < 0) {
                            NIConsolePartitioner.this.setUpdateInProgress(true);
                            NIConsolePartitioner.this.document.set("");
                            NIConsolePartitioner.this.setUpdateInProgress(false);
                            NIConsolePartitioner.this.partitions.clear();
                        } else {
                            int cutoffLine = NIConsolePartitioner.this.document.getLineOfOffset(this.truncateOffset);
                            int cutOffset = NIConsolePartitioner.this.document.getLineOffset(cutoffLine);
                            NIConsolePartition partition = (NIConsolePartition)NIConsolePartitioner.this.getPartition(cutOffset);
                            partition.setLength(partition.getOffset() + partition.getLength() - cutOffset);
                            NIConsolePartitioner.this.setUpdateInProgress(true);
                            NIConsolePartitioner.this.document.replace(0, cutOffset, "");
                            NIConsolePartitioner.this.setUpdateInProgress(false);
                            int index = NIConsolePartitioner.this.partitions.indexOf(partition);
                            int i = 0;
                            while (i < index) {
                                NIConsolePartitioner.this.partitions.remove(0);
                                ++i;
                            }
                            int offset = 0;
                            for (NIConsolePartition p : NIConsolePartitioner.this.partitions) {
                                p.setOffset(offset);
                                offset += p.getLength();
                            }
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
            return Status.OK_STATUS;
        }
    }
}

