/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.console.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.console.core.util.LoadReferenceRunnable;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.rj.data.RReference;

public class LoadReferencesUtil {
    public static final int MAX_EXPLICITE_WAIT = 250;
    public static final int MAX_AUTO_WAIT = 100;
    private final RProcess tool;
    private final Map<Object, LoadRunnable> resolveTasks = new HashMap<Object, LoadRunnable>();
    private final AtomicInteger resolveTasksScheduled = new AtomicInteger();
    private long waitMillis;
    private List<CombinedRElement> resolvedElements;

    public LoadReferencesUtil(RProcess tool, long waitTimeout) {
        if (tool == null) {
            throw new NullPointerException("tool");
        }
        this.tool = tool;
        this.waitMillis = waitTimeout;
    }

    public long getWaitTimeout() {
        return this.waitMillis;
    }

    public void setWaitTimeout(long millis) {
        this.waitMillis = millis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CombinedRElement resolve(RReference reference, int loadOptions) {
        if (!(reference instanceof CombinedRElement)) {
            return null;
        }
        RProcess elementProcess = LoadReferenceRunnable.findRProcess((CombinedRElement)reference);
        if (elementProcess != this.tool) {
            return null;
        }
        Long key = reference.getHandle();
        LoadRunnable task = this.resolveTasks.get(key);
        if (task != null) {
            int currentOptions = task.getLoadOptions();
            if ((currentOptions & loadOptions) == loadOptions) {
                return null;
            }
            LoadRunnable loadRunnable = task;
            synchronized (loadRunnable) {
                if (!task.isStarted()) {
                    task.setLoadOptions(currentOptions | loadOptions);
                    return null;
                }
            }
        }
        task = new LoadRunnable(reference, this.tool, 0, "Content Assist");
        this.resolveTasks.put(key, task);
        return this.schedule(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CombinedRElement resolve(RElementName name, int loadOptions) {
        RElementName key = name;
        LoadRunnable task = this.resolveTasks.get(key);
        if (task != null) {
            int currentOptions = task.getLoadOptions();
            if ((currentOptions & loadOptions) == loadOptions) {
                return task.getResolvedElement();
            }
            LoadRunnable loadRunnable = task;
            synchronized (loadRunnable) {
                if (!task.isStarted()) {
                    task.setLoadOptions(currentOptions | loadOptions);
                    return null;
                }
            }
        }
        if (!LoadReferenceRunnable.isAccessAllowed(name, this.tool.getWorkspaceData())) {
            return null;
        }
        task = new LoadRunnable(name, this.tool, 0, "Content Assist");
        this.resolveTasks.put(key, task);
        return this.schedule(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CombinedRElement schedule(LoadRunnable task) {
        LoadRunnable loadRunnable = task;
        synchronized (loadRunnable) {
            long startTime = System.nanoTime();
            if (task.getTool().getQueue().addHot((ToolRunnable)task).getSeverity() != 0) return null;
            try {
                long wait = this.waitMillis;
                if (wait > 0L) {
                    task.wait(wait);
                }
                if (task.isFinished()) {
                    CombinedRElement combinedRElement = task.getResolvedElement();
                    return combinedRElement;
                }
                this.resolveTasksScheduled.incrementAndGet();
                return null;
            }
            catch (InterruptedException e) {
                task.cancel();
            }
            finally {
                this.waitMillis -= TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
            }
            return null;
        }
    }

    protected void taskFinished(LoadRunnable runnable) {
        CombinedRElement element = runnable.getResolvedElement();
        if (element != null) {
            if (this.resolvedElements == null) {
                this.resolvedElements = new ArrayList<CombinedRElement>();
            }
            this.resolvedElements.add(element);
        }
        if (this.resolveTasksScheduled.decrementAndGet() == 0) {
            this.allFinished((ImList<CombinedRElement>)(this.resolvedElements != null ? ImCollections.toList(this.resolvedElements) : ImCollections.emptyList()));
        }
    }

    protected void allFinished(ImList<CombinedRElement> resolvedElements) {
    }

    private class LoadRunnable
    extends LoadReferenceRunnable
    implements Runnable {
        public LoadRunnable(RReference reference, RProcess tool, int stamp, String cause) {
            super(reference, tool, stamp, cause);
            this.setFinishRunnable(this);
        }

        public LoadRunnable(RElementName name, RProcess tool, int stamp, String cause) {
            super(name, tool, stamp, cause);
            this.setFinishRunnable(this);
        }

        @Override
        public void run() {
            LoadReferencesUtil.this.taskFinished(this);
        }
    }
}

