/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.nico.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.internal.r.console.core.RConsoleCorePlugin;
import org.eclipse.statet.internal.r.nico.RNicoMessages;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.WarningStatus;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.r.console.core.IRBasicAdapter;
import org.eclipse.statet.r.nico.impl.RTermController;
import org.eclipse.statet.rj.renv.core.REnvConfiguration;

class RTermCancelRunnable
implements ToolRunnable {
    RTermCancelRunnable() {
    }

    public String getLabel() {
        return RNicoMessages.RTerm_CancelTask_label;
    }

    public String getTypeId() {
        return null;
    }

    public boolean changed(int event, Tool process) {
        return true;
    }

    public boolean canRunIn(Tool tool) {
        return true;
    }

    public void run(ToolService service, ProgressMonitor m) throws StatusException {
        IRBasicAdapter r = (IRBasicAdapter)service;
        REnvConfiguration rEnvConfig = r.getTool().getAdapter(REnvConfiguration.class);
        String arch = rEnvConfig.getRArch();
        if (arch == null) {
            arch = Platform.getOSArch();
        }
        try {
            m.beginTask(RNicoMessages.RTerm_CancelTask_SendSignal_label, 10);
            URL url = RConsoleCorePlugin.getInstance().getBundle().getEntry("/win32/" + arch + "/sendsignal.exe");
            if (url == null) {
                throw new IOException("Missing 'sendsignal' tool for arch '" + arch + "'.");
            }
            File file = new File((url = FileLocator.toFileURL((URL)url)).getPath());
            if (!file.exists()) {
                throw new IOException("Missing file '" + url.toExternalForm() + "'.");
            }
            m.addWorked(1);
            RTermController controller = (RTermController)r.getController();
            Long processId = controller.fProcessId;
            if (processId == null) {
                RConsoleCorePlugin.log((IStatus)new Status(2, "org.eclipse.statet.r.console.core", "Cannot run cancel command: process-id of Rterm process is missing."));
                return;
            }
            Object[] cmd = new String[]{file.getAbsolutePath(), processId.toString()};
            Process process = Runtime.getRuntime().exec((String[])cmd);
            m.addWorked(1);
            while (true) {
                try {
                    int code = process.exitValue();
                    if (code != 0) {
                        StringBuilder detail = new StringBuilder("Command failed:");
                        detail.append("\n command = ");
                        detail.append(Arrays.toString(cmd));
                        detail.append("\n os.name = ");
                        detail.append(System.getProperty("os.name"));
                        detail.append("\n os.version = ");
                        detail.append(System.getProperty("os.version"));
                        detail.append("\n os.arch = ");
                        detail.append(System.getProperty("os.arch"));
                        detail.append("\n r.arch = ");
                        detail.append(arch);
                        detail.append("\n exit.code = 0x");
                        detail.append(Integer.toHexString(code));
                        throw new IOException(detail.toString());
                    }
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    if (m.isCanceled()) {
                        process.destroy();
                        RConsoleCorePlugin.log((IStatus)new Status(2, "org.eclipse.statet.r.console.core", -1, "Sending CTRL+C to R process canceled, command: " + Arrays.toString(cmd), null));
                        break;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new StatusException((org.eclipse.statet.jcommons.status.Status)new WarningStatus("org.eclipse.statet.r.console.core", "Error Sending CTRL+C to R process.", (Throwable)e));
        }
    }
}

