/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.console.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.statet.ecommons.ui.util.ImageRegistryUtil;
import org.eclipse.statet.internal.r.console.ui.snippets.RSnippets;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class RConsoleUIPlugin
extends AbstractUIPlugin {
    public static final String BUNDLE_ID = "org.eclipse.statet.r.console.ui";
    public static final String IMG_OBJ_SNIPPETS = "org.eclipse.statet.r.console.ui/image/obj/snippets";
    private static RConsoleUIPlugin instance;
    private boolean started;
    private RSnippets rSnippets;

    public static RConsoleUIPlugin getInstance() {
        return instance;
    }

    public static final void log(IStatus status) {
        RConsoleUIPlugin plugin = RConsoleUIPlugin.getInstance();
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public static final void logError(String message, Throwable e) {
        RConsoleUIPlugin.log((IStatus)new Status(4, BUNDLE_ID, message, e));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            RConsoleUIPlugin rConsoleUIPlugin = this;
            synchronized (rConsoleUIPlugin) {
                this.started = false;
            }
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        ImageRegistryUtil util = new ImageRegistryUtil((AbstractUIPlugin)this);
        util.register(IMG_OBJ_SNIPPETS, "obj_16", "snippets.png");
    }

    public synchronized RSnippets getRSnippets() {
        if (this.rSnippets == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.rSnippets = new RSnippets();
        }
        return this.rSnippets;
    }
}

