/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.rsource.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.r.core.rlang.RTerminal;
import org.eclipse.statet.r.core.rsource.ast.Expression;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RAstVisitor;

@NonNullByDefault
public final class NullConst
extends RAstNode {
    NullConst() {
    }

    @Override
    public final NodeType getNodeType() {
        return NodeType.NULL_CONST;
    }

    @Override
    public final @Nullable RTerminal getOperator(int index) {
        return null;
    }

    @Override
    public final boolean hasChildren() {
        return false;
    }

    @Override
    public final int getChildCount() {
        return 0;
    }

    @Override
    public final RAstNode getChild(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final RAstNode[] getChildren() {
        return NO_CHILDREN;
    }

    @Override
    public final int getChildIndex(AstNode child) {
        return -1;
    }

    @Override
    public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public final void acceptInRChildren(RAstVisitor visitor) {
    }

    public final void acceptInChildren(AstVisitor visitor) {
    }

    @Override
    final @Nullable Expression getExpr(RAstNode child) {
        return null;
    }

    @Override
    final @Nullable Expression getLeftExpr() {
        return null;
    }

    @Override
    final @Nullable Expression getRightExpr() {
        return null;
    }

    @Override
    public final boolean equalsSingle(RAstNode element) {
        return NodeType.NULL_CONST == element.getNodeType();
    }

    @Override
    final int getMissingExprStatus(Expression expr) {
        throw new IllegalArgumentException();
    }

    @Override
    public boolean equalsValue(RAstNode element) {
        return NodeType.NULL_CONST == element.getNodeType();
    }
}

